/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.keyboard;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.behaviors.keyboard.KeyNavigator;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.media.j3d.Behavior;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.media.j3d.WakeupOr;

public class KeyNavigatorBehavior
extends Behavior
implements KeyListener {
    private WakeupCriterion w1 = new WakeupOnAWTEvent(401);
    private WakeupCriterion w2 = new WakeupOnAWTEvent(402);
    private WakeupOnElapsedFrames w3 = new WakeupOnElapsedFrames(0);
    private WakeupCriterion[] warray = new WakeupCriterion[]{this.w1, this.w2, this.w3};
    private WakeupCondition w = new WakeupOr(this.warray);
    private KeyEvent eventKey;
    private KeyNavigator keyNavigator;
    private boolean listener = false;
    private LinkedList eventq;

    public void initialize() {
        if (this.listener) {
            this.w1 = new WakeupOnBehaviorPost((Behavior)this, 401);
            this.w2 = new WakeupOnBehaviorPost((Behavior)this, 402);
            this.warray[0] = this.w1;
            this.warray[1] = this.w2;
            this.w = new WakeupOr(this.warray);
            this.eventq = new LinkedList();
        }
        this.wakeupOn(this.w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStimulus(Enumeration enumeration) {
        boolean bl = false;
        block3: while (enumeration.hasMoreElements()) {
            WakeupCriterion wakeupCriterion = (WakeupCriterion)enumeration.nextElement();
            if (wakeupCriterion instanceof WakeupOnAWTEvent) {
                WakeupOnAWTEvent wakeupOnAWTEvent = (WakeupOnAWTEvent)wakeupCriterion;
                AWTEvent[] aWTEventArray = wakeupOnAWTEvent.getAWTEvent();
                this.processAWTEvent(aWTEventArray);
                continue;
            }
            if (wakeupCriterion instanceof WakeupOnElapsedFrames && this.eventKey != null) {
                bl = true;
                continue;
            }
            if (!(wakeupCriterion instanceof WakeupOnBehaviorPost)) continue;
            while (true) {
                LinkedList linkedList = this.eventq;
                synchronized (linkedList) {
                    if (this.eventq.isEmpty()) {
                        continue block3;
                    }
                    this.eventKey = (KeyEvent)this.eventq.remove(0);
                    if (this.eventKey.getID() == 401 || this.eventKey.getID() == 402) {
                        this.keyNavigator.processKeyEvent(this.eventKey);
                    }
                }
            }
        }
        if (bl) {
            this.keyNavigator.integrateTransformChanges();
        }
        this.wakeupOn(this.w);
    }

    private void processAWTEvent(AWTEvent[] aWTEventArray) {
        int n = 0;
        while (n < aWTEventArray.length) {
            if (aWTEventArray[n] instanceof KeyEvent) {
                this.eventKey = (KeyEvent)aWTEventArray[n];
                if (this.eventKey.getID() == 401 || this.eventKey.getID() == 402) {
                    this.keyNavigator.processKeyEvent(this.eventKey);
                }
            }
            ++n;
        }
    }

    public void addListener(Component component) {
        if (!this.listener) {
            throw new IllegalStateException(J3dUtilsI18N.getString("Behavior0"));
        }
        component.addKeyListener(this);
    }

    public KeyNavigatorBehavior(TransformGroup transformGroup) {
        this.keyNavigator = new KeyNavigator(transformGroup);
    }

    public KeyNavigatorBehavior(Component component, TransformGroup transformGroup) {
        this(transformGroup);
        if (component != null) {
            component.addKeyListener(this);
        }
        this.listener = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(KeyEvent keyEvent) {
        LinkedList linkedList = this.eventq;
        synchronized (linkedList) {
            this.eventq.add(keyEvent);
            if (this.eventq.size() == 1) {
                this.postId(401);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyReleased(KeyEvent keyEvent) {
        LinkedList linkedList = this.eventq;
        synchronized (linkedList) {
            this.eventq.add(keyEvent);
            if (this.eventq.size() == 1) {
                this.postId(402);
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

