/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.compression;

import com.sun.j3d.utils.compression.CommandStream;
import com.sun.j3d.utils.compression.CompressionStream;
import com.sun.j3d.utils.compression.CompressionStreamElement;
import com.sun.j3d.utils.compression.HuffmanNode;
import com.sun.j3d.utils.compression.HuffmanTable;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;

class CompressionStreamColor
extends CompressionStreamElement {
    private int R;
    private int G;
    private int B;
    private int A;
    private boolean color3;
    private boolean color4;
    private float colorR;
    private float colorG;
    private float colorB;
    private float colorA;
    int rAbsolute;
    int gAbsolute;
    int bAbsolute;
    int aAbsolute;

    CompressionStreamColor(CompressionStream compressionStream, Color3f color3f) {
        this.color4 = false;
        this.color3 = true;
        this.colorR = color3f.x;
        this.colorG = color3f.y;
        this.colorB = color3f.z;
        this.colorA = 0.0f;
        compressionStream.byteCount += 12;
    }

    CompressionStreamColor(CompressionStream compressionStream, Color4f color4f) {
        this.color3 = false;
        this.color4 = true;
        this.colorR = color4f.x;
        this.colorG = color4f.y;
        this.colorB = color4f.z;
        this.colorA = color4f.w;
        compressionStream.byteCount += 16;
    }

    void quantize(CompressionStream compressionStream, HuffmanTable huffmanTable) {
        int n = compressionStream.colorQuant < 2 ? 2 : (compressionStream.colorQuant > 16 ? 16 : compressionStream.colorQuant);
        this.absolute = false;
        if (compressionStream.firstColor || compressionStream.colorQuantChanged) {
            this.absolute = true;
            compressionStream.lastColor[0] = 0;
            compressionStream.lastColor[1] = 0;
            compressionStream.lastColor[2] = 0;
            compressionStream.lastColor[3] = 0;
            compressionStream.firstColor = false;
            compressionStream.colorQuantChanged = false;
        }
        if (this.color3) {
            this.R = (int)((double)this.colorR * 32768.0);
            this.G = (int)((double)this.colorG * 32768.0);
            this.B = (int)((double)this.colorB * 32768.0);
            this.A = 0;
        } else if (this.color4) {
            this.R = (int)((double)this.colorR * 32768.0);
            this.G = (int)((double)this.colorG * 32768.0);
            this.B = (int)((double)this.colorB * 32768.0);
            this.A = (int)((double)this.colorA * 32768.0);
        }
        int n2 = this.R > Short.MAX_VALUE ? Short.MAX_VALUE : (this.R = this.R < 0 ? 0 : this.R);
        int n3 = this.G > Short.MAX_VALUE ? Short.MAX_VALUE : (this.G = this.G < 0 ? 0 : this.G);
        int n4 = this.B > Short.MAX_VALUE ? Short.MAX_VALUE : (this.B = this.B < 0 ? 0 : this.B);
        this.A = this.A > Short.MAX_VALUE ? Short.MAX_VALUE : (this.A < 0 ? 0 : this.A);
        this.R &= CompressionStreamElement.quantizationMask[n];
        this.G &= CompressionStreamElement.quantizationMask[n];
        this.B &= CompressionStreamElement.quantizationMask[n];
        this.A &= CompressionStreamElement.quantizationMask[n];
        this.rAbsolute = this.R;
        this.gAbsolute = this.G;
        this.bAbsolute = this.B;
        this.aAbsolute = this.A;
        this.R -= compressionStream.lastColor[0];
        this.G -= compressionStream.lastColor[1];
        this.B -= compressionStream.lastColor[2];
        this.A -= compressionStream.lastColor[3];
        compressionStream.lastColor[0] = compressionStream.lastColor[0] + this.R;
        compressionStream.lastColor[1] = compressionStream.lastColor[1] + this.G;
        compressionStream.lastColor[2] = compressionStream.lastColor[2] + this.B;
        compressionStream.lastColor[3] = compressionStream.lastColor[3] + this.A;
        if (this.color3) {
            this.computeLengthShift(this.R, this.G, this.B);
        } else if (this.color4) {
            this.computeLengthShift(this.R, this.G, this.B, this.A);
        }
        if (this.length == 0) {
            this.length = 1;
        }
        huffmanTable.addColorEntry(this.length, this.shift, this.absolute);
    }

    void outputCommand(HuffmanTable huffmanTable, CommandStream commandStream) {
        this.outputColor(huffmanTable, commandStream, 128, 8);
    }

    void outputSubcommand(HuffmanTable huffmanTable, CommandStream commandStream) {
        this.outputColor(huffmanTable, commandStream, 0, 6);
    }

    private void outputColor(HuffmanTable huffmanTable, CommandStream commandStream, int n, int n2) {
        HuffmanNode huffmanNode = huffmanTable.getColorEntry(this.length, this.shift, this.absolute);
        int n3 = huffmanNode.dataLength - huffmanNode.shift;
        int n4 = huffmanNode.tagLength + 3 * n3;
        this.R = this.R >> huffmanNode.shift & (int)CompressionStreamElement.lengthMask[n3];
        this.G = this.G >> huffmanNode.shift & (int)CompressionStreamElement.lengthMask[n3];
        this.B = this.B >> huffmanNode.shift & (int)CompressionStreamElement.lengthMask[n3];
        long l = (long)huffmanNode.tag << 3 * n3 | (long)this.R << 2 * n3 | (long)this.G << 1 * n3 | (long)this.B << 0 * n3;
        if (n4 < 6) {
            n |= (int)(l << 6 - n4);
            n4 = 0;
        } else {
            n |= (int)(l >>> n4 - 6);
            n4 -= 6;
        }
        if (this.color4) {
            this.A = this.A >> huffmanNode.shift & (int)CompressionStreamElement.lengthMask[n3];
            l = l << n3 | (long)this.A;
            n4 += n3;
        }
        commandStream.addCommand(n, n2, l, n4);
    }

    public String toString() {
        String string = this.absolute ? "" : "delta ";
        String string2 = this.colorR + " " + this.colorG + " " + this.colorB + (this.color4 ? " " + this.colorA : "");
        return "color: " + string2 + "\n" + " fixed point " + string + this.R + " " + this.G + " " + this.B + "\n" + " length " + this.length + " shift " + this.shift + (this.absolute ? " absolute" : " relative");
    }
}

