/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.BBox;
import com.sun.j3d.utils.geometry.BottleNeck;
import com.sun.j3d.utils.geometry.Degenerate;
import com.sun.j3d.utils.geometry.Numerics;
import com.sun.j3d.utils.geometry.PntNode;
import com.sun.j3d.utils.geometry.Triangulator;

class NoHash {
    static final int NIL = -1;

    NoHash() {
    }

    static void insertAfterVtx(Triangulator triangulator, int n) {
        if (triangulator.vtxList == null) {
            int n2 = Math.max(triangulator.numVtxList + 1, 100);
            triangulator.vtxList = new PntNode[n2];
        } else if (triangulator.numVtxList >= triangulator.vtxList.length) {
            int n3 = Math.max(triangulator.numVtxList + 1, triangulator.vtxList.length + 100);
            PntNode[] pntNodeArray = triangulator.vtxList;
            triangulator.vtxList = new PntNode[n3];
            System.arraycopy(pntNodeArray, 0, triangulator.vtxList, 0, pntNodeArray.length);
        }
        triangulator.vtxList[triangulator.numVtxList] = new PntNode();
        triangulator.vtxList[triangulator.numVtxList].pnt = n;
        triangulator.vtxList[triangulator.numVtxList].next = triangulator.reflexVertices;
        triangulator.reflexVertices = triangulator.numVtxList++;
        ++triangulator.numReflex;
    }

    static void deleteFromList(Triangulator triangulator, int n) {
        int n2;
        if (triangulator.numReflex == 0) {
            return;
        }
        int n3 = triangulator.reflexVertices;
        if (!NoHash.inVtxList(triangulator, n3)) {
            System.out.println("NoHash:deleteFromList. Problem :Not is InVtxList ..." + n3);
        }
        if ((n2 = triangulator.vtxList[n3].pnt) == n) {
            triangulator.reflexVertices = triangulator.vtxList[n3].next;
            --triangulator.numReflex;
        } else {
            int n4 = triangulator.vtxList[n3].next;
            while (n4 != -1) {
                if (!NoHash.inVtxList(triangulator, n4)) {
                    System.out.println("NoHash:deleteFromList. Problem :Not is InVtxList ..." + n4);
                }
                if ((n2 = triangulator.vtxList[n4].pnt) == n) {
                    triangulator.vtxList[n3].next = triangulator.vtxList[n4].next;
                    n4 = -1;
                    --triangulator.numReflex;
                    continue;
                }
                n3 = n4;
                n4 = triangulator.vtxList[n3].next;
            }
        }
    }

    static boolean inVtxList(Triangulator triangulator, int n) {
        return 0 <= n && n < triangulator.numVtxList;
    }

    static void freeNoHash(Triangulator triangulator) {
        triangulator.noHashingEdges = false;
        triangulator.noHashingPnts = false;
        triangulator.numVtxList = 0;
    }

    static void prepareNoHashEdges(Triangulator triangulator, int n, int n2) {
        triangulator.loopMin = n;
        triangulator.loopMax = n2;
        triangulator.noHashingEdges = true;
    }

    static void prepareNoHashPnts(Triangulator triangulator, int n) {
        int n2;
        triangulator.numVtxList = 0;
        triangulator.reflexVertices = -1;
        int n3 = n2 = triangulator.loops[n];
        triangulator.numReflex = 0;
        int n4 = triangulator.fetchData(n3);
        do {
            if (triangulator.getAngle(n3) < 0) {
                NoHash.insertAfterVtx(triangulator, n3);
            }
            n3 = triangulator.fetchNextData(n3);
            n4 = triangulator.fetchData(n3);
        } while (n3 != n2);
        triangulator.noHashingPnts = true;
    }

    static boolean noHashIntersectionExists(Triangulator triangulator, int n, int n2, int n3, int n4, BBox bBox) {
        int[] nArray = new int[1];
        if (!triangulator.noHashingPnts) {
            System.out.println("NoHash:noHashIntersectionExists noHashingPnts is false");
        }
        if (triangulator.numReflex <= 0) {
            return false;
        }
        if (n < bBox.imin) {
            bBox.imin = n;
        } else if (n > bBox.imax) {
            bBox.imax = n;
        }
        double d = triangulator.points[n].y;
        if (d < bBox.ymin) {
            bBox.ymin = d;
        } else if (d > bBox.ymax) {
            bBox.ymax = d;
        }
        int n5 = triangulator.reflexVertices;
        boolean bl = false;
        do {
            int n6;
            int n7;
            if (!bBox.pntInBBox(triangulator, n7 = triangulator.fetchData(n6 = triangulator.vtxList[n5].pnt))) continue;
            int n8 = triangulator.fetchNextData(n6);
            int n9 = triangulator.fetchData(n8);
            if (n6 == n2 || n6 == n8 || !(n7 == n ? Degenerate.handleDegeneracies(triangulator, n, n2, n3, n4, n7, n6) : n7 != n3 && n7 != n4 && (bl = Numerics.vtxInTriangle(triangulator, n, n3, n4, n7, nArray)))) continue;
            return true;
        } while ((n5 = triangulator.vtxList[n5].next) != -1);
        return false;
    }

    static void deleteReflexVertex(Triangulator triangulator, int n) {
        NoHash.deleteFromList(triangulator, n);
    }

    static boolean noHashEdgeIntersectionExists(Triangulator triangulator, BBox bBox, int n, int n2, int n3, int n4) {
        if (!triangulator.noHashingEdges) {
            System.out.println("NoHash:noHashEdgeIntersectionExists noHashingEdges is false");
        }
        triangulator.identCntr = 0;
        int n5 = triangulator.loopMin;
        while (n5 < triangulator.loopMax) {
            int n6;
            int n7 = n6 = triangulator.loops[n5];
            int n8 = triangulator.fetchData(n7);
            do {
                int n9;
                BBox bBox2;
                if (bBox.BBoxOverlap(bBox2 = new BBox(triangulator, n8, n9 = triangulator.fetchData(n7 = triangulator.fetchNextData(n7)))) && Numerics.segIntersect(triangulator, bBox.imin, bBox.imax, bBox2.imin, bBox2.imax, n4)) {
                    return true;
                }
                n8 = n9;
            } while (n7 != n6);
            ++n5;
        }
        if (triangulator.identCntr >= 4) {
            return BottleNeck.checkBottleNeck(triangulator, n4, n, n2, n3);
        }
        return false;
    }
}

