/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.headspace;

import com.sun.j3d.audioengines.headspace.AudioAiffInputStream;
import com.sun.j3d.audioengines.headspace.AudioAuInputStream;
import com.sun.j3d.audioengines.headspace.AudioDataStream;
import com.sun.j3d.audioengines.headspace.AudioFormat;
import com.sun.j3d.audioengines.headspace.AudioMidiInputStream;
import com.sun.j3d.audioengines.headspace.AudioRmfInputStream;
import com.sun.j3d.audioengines.headspace.AudioStream;
import com.sun.j3d.audioengines.headspace.AudioWavInputStream;
import com.sun.j3d.audioengines.headspace.BadAudioHeaderException;
import com.sun.j3d.audioengines.headspace.Format;
import com.sun.j3d.audioengines.headspace.HaeDevice;
import com.sun.j3d.audioengines.headspace.HaeException;
import com.sun.j3d.audioengines.headspace.HaeMixer;
import com.sun.j3d.audioengines.headspace.MediaInputStream;
import com.sun.j3d.audioengines.headspace.NativeAudioStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

class AudioContainerInputStream
extends MediaInputStream {
    protected boolean DEBUG = false;
    static final int MIDI_MAGIC = 1297377380;
    static final int AIFF_MAGIC = 1179603533;
    static final int RMF_MAGIC = 1230128474;
    static final int RIFF_MAGIC = 1380533830;
    static final int WAV_MAGIC = 1463899717;
    static final int AU_SUN_MAGIC = 779316836;
    static final int AU_DEC_MAGIC = 779314176;
    static final int AU_SUN_INV_MAGIC = 1684960046;
    static final int AU_DEC_INV_MAGIC = 6583086;
    static final int[] ULAW_TABH = new int[]{130, 134, 138, 142, 146, 150, 154, 158, 162, 166, 170, 174, 178, 182, 186, 190, 193, 195, 197, 199, 201, 203, 205, 207, 209, 211, 213, 215, 217, 219, 221, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 241, 242, 242, 243, 243, 244, 244, 245, 245, 246, 246, 247, 247, 248, 248, 248, 249, 249, 249, 249, 250, 250, 250, 250, 251, 251, 251, 251, 252, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 126, 121, 117, 113, 109, 105, 101, 97, 93, 89, 85, 81, 77, 73, 69, 65, 62, 60, 58, 56, 54, 52, 50, 48, 46, 44, 42, 40, 38, 36, 34, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 14, 13, 13, 12, 12, 11, 11, 10, 10, 9, 9, 8, 8, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 5, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final int[] ULAW_TABL = new int[]{0, 4, 8, 12, 17, 21, 25, 29, 33, 38, 42, 46, 50, 55, 59, 63, 66, 68, 71, 73, 75, 77, 79, 81, 83, 85, 88, 90, 92, 94, 96, 98, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 243, 244, 180, 53, 181, 54, 182, 55, 184, 56, 185, 57, 186, 58, 187, 59, 188, 60, 157, 221, 29, 94, 158, 222, 30, 95, 159, 223, 31, 96, 160, 224, 32, 97, 145, 177, 209, 241, 17, 50, 82, 114, 146, 178, 210, 242, 18, 51, 83, 115, 139, 155, 171, 187, 203, 219, 235, 251, 11, 28, 44, 60, 76, 92, 108, 124, 136, 144, 152, 160, 168, 176, 184, 192, 200, 208, 216, 224, 232, 240, 248, 0, 0, 252, 248, 244, 239, 235, 231, 227, 223, 218, 214, 210, 206, 201, 197, 193, 190, 188, 185, 183, 181, 179, 177, 175, 173, 171, 168, 166, 164, 162, 160, 158, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 13, 12, 76, 203, 75, 202, 74, 201, 72, 200, 71, 199, 70, 198, 69, 197, 68, 196, 99, 35, 227, 162, 98, 34, 226, 161, 97, 33, 225, 160, 96, 32, 224, 159, 111, 79, 47, 15, 239, 206, 174, 142, 110, 78, 46, 14, 238, 205, 173, 141, 117, 101, 85, 69, 53, 37, 21, 5, 245, 228, 212, 196, 180, 164, 148, 132, 120, 112, 104, 96, 88, 80, 72, 64, 56, 48, 40, 32, 24, 16, 8, 0};
    AudioFormat f;
    AudioFormat fout;
    boolean streamFinished = false;
    boolean processBytes = false;
    boolean swapBytes = false;
    boolean convertFromUlaw = false;
    boolean convertUnsigned = false;
    boolean mixerBigEndian = false;
    InputStream stream;
    InputStream streamSrc;
    ArrayList sharedInputContainers = null;
    byte[] cachedBuffer = null;
    static final int MAX_HEADER_SIZE = 12;
    protected int totalBytes = 0;
    protected int totalFrames = 0;
    protected int currentFrame = 0;
    protected int headerSize = 0;
    float filterCutoffFreq = 44100.0f;
    boolean filterFlag = false;

    protected AudioContainerInputStream(byte[] byArray, InputStream inputStream) throws IOException, BadAudioHeaderException {
        super(inputStream);
        this.stream = inputStream;
        this.streamSrc = inputStream;
        AudioFormat audioFormat = this.readFormat(byArray);
        this.setFormat(audioFormat);
        this.setupConversions();
    }

    AudioContainerInputStream(AudioFormat audioFormat, InputStream inputStream) throws BadAudioHeaderException {
        super(inputStream);
        this.stream = inputStream;
        this.streamSrc = inputStream;
        if (audioFormat == null || audioFormat.getEncoding() == null) {
            throw new BadAudioHeaderException("invalid format object");
        }
        this.setFormat(audioFormat);
        this.setupConversions();
    }

    protected AudioContainerInputStream(AudioContainerInputStream audioContainerInputStream) {
        super(audioContainerInputStream.streamSrc);
        this.f = audioContainerInputStream.f;
        this.fout = audioContainerInputStream.fout;
        this.streamFinished = audioContainerInputStream.streamFinished;
        this.processBytes = audioContainerInputStream.processBytes;
        this.swapBytes = audioContainerInputStream.swapBytes;
        this.convertFromUlaw = audioContainerInputStream.convertFromUlaw;
        this.mixerBigEndian = audioContainerInputStream.mixerBigEndian;
        this.stream = audioContainerInputStream.stream;
        this.streamSrc = audioContainerInputStream.streamSrc;
        this.totalBytes = audioContainerInputStream.totalBytes;
        this.totalFrames = audioContainerInputStream.totalFrames;
        this.currentFrame = audioContainerInputStream.currentFrame;
        this.headerSize = audioContainerInputStream.headerSize;
        this.filterCutoffFreq = audioContainerInputStream.filterCutoffFreq;
        this.filterFlag = audioContainerInputStream.filterFlag;
        if (audioContainerInputStream.sharedInputContainers == null) {
            audioContainerInputStream.sharedInputContainers = new ArrayList();
            audioContainerInputStream.sharedInputContainers.add(audioContainerInputStream);
        }
        audioContainerInputStream.sharedInputContainers.add(this);
        this.sharedInputContainers = audioContainerInputStream.sharedInputContainers;
    }

    protected void setFormat(Format format) {
        if (format instanceof AudioFormat) {
            this.f = (AudioFormat)format;
            this.totalFrames = this.getTotalBytes() / (this.f.getChannels() * this.f.getSampleSize());
        } else if (format != null) {
            System.out.println("not a valid audio format!");
        }
    }

    protected void setupConversions() throws BadAudioHeaderException {
        if (this.f == null) {
            return;
        }
        if (!"JAUDIO_LINEAR".equals(this.f.getEncoding()) && !"JAUDIO_G711_ULAW".equals(this.f.getEncoding())) {
            throw new BadAudioHeaderException("Unsupported audio encoding: " + this.f.getEncoding());
        }
        try {
            HaeMixer haeMixer = HaeDevice.getSystemMixer();
            if (haeMixer != null) {
                this.mixerBigEndian = haeMixer.isBigEndian();
            }
        }
        catch (HaeException haeException) {
            throw new BadAudioHeaderException("Mixer not initialized");
        }
        if (this.f.isBigEndian() == this.mixerBigEndian) {
            this.swapBytes = false;
        } else {
            boolean bl = this.swapBytes = this.f.getSampleSize() != 1;
        }
        if (this.f.isSigned() && this.f.getEncoding() != null && this.f.getSampleSize() == 1 && this.f.getEncoding().equals("JAUDIO_LINEAR")) {
            this.convertUnsigned = true;
        }
        if (this.f.getEncoding().equals("JAUDIO_G711_ULAW")) {
            if (this.f.getChannels() != 1) {
                throw new BadAudioHeaderException("Stereo ulaw");
            }
            this.convertFromUlaw = true;
        }
        if (this.swapBytes || this.convertUnsigned || this.convertFromUlaw) {
            this.processBytes = true;
            this.fout = new AudioFormat(this.f.getSampleRate(), this.convertFromUlaw ? "JAUDIO_LINEAR" : this.f.getEncoding(), this.convertFromUlaw ? 2 : this.f.getSampleSize(), this.f.getSamplePerUnit(), this.f.getChannels(), this.mixerBigEndian, this.convertUnsigned ? false : this.f.isSigned());
        } else {
            this.fout = this.f;
        }
        if (this.DEBUG) {
            System.out.println("format conversions: processBytes: " + this.processBytes + " swapBytes: " + this.swapBytes + "  convertUnsigned: " + this.convertUnsigned + " convertFromUlaw: " + this.convertFromUlaw);
            System.out.println("input format: " + this.f.toString());
            System.out.println("output format: " + this.fout.toString());
        }
    }

    int getConvertedData(byte[] byArray, int n) throws IOException {
        int n2;
        int n3;
        if (this.f == null) {
            return 0;
        }
        if (byArray == null || n <= 0) {
            return 0;
        }
        int n4 = this.f.getSampleSize() * this.f.getChannels();
        int n5 = this.fout.getSampleSize() * this.fout.getChannels();
        if (n * n5 > byArray.length) {
            n = byArray.length / n5;
        }
        int n6 = n3 = n * n5;
        int n7 = 0;
        if (this.convertFromUlaw) {
            n7 = n3 / 2;
            n6 /= 2;
        }
        int n8 = 0;
        int n9 = 0;
        while ((n8 = this.stream.read(byArray, n7, n6)) > 0) {
            n9 += n8;
            n7 += n8;
            if ((n6 -= n8) != 0 && this.stream.available() != 0) continue;
        }
        if (n8 == -1) {
            this.streamFinished = true;
        }
        if (n9 == 0) {
            return 0;
        }
        if (this.processBytes) {
            n2 = 0;
            if (this.swapBytes) {
                while (n2 < n3) {
                    byte by = byArray[n2];
                    byte by2 = byArray[n2 + 1];
                    if (this.convertUnsigned) {
                        by = (byte)(by ^ 0x80);
                        by2 = (byte)(by2 ^ 0x80);
                    }
                    byArray[n2] = by2;
                    byArray[n2 + 1] = by;
                    n2 += 2;
                }
            } else if (this.convertFromUlaw) {
                boolean bl = this.mixerBigEndian;
                int[] nArray = ULAW_TABL;
                int[] nArray2 = ULAW_TABH;
                n7 = n3 / 2;
                while (n7 < n3) {
                    byArray[n2] = bl ? (byte)nArray2[byArray[n7] & 0xFF] : (byte)nArray[byArray[n7] & 0xFF];
                    byArray[n2 + 1] = bl ? (byte)nArray[byArray[n7] & 0xFF] : (byte)nArray2[byArray[n7] & 0xFF];
                    n2 += 2;
                    ++n7;
                }
            } else if (this.convertUnsigned) {
                while (n2 < n3) {
                    byte by = byArray[n2];
                    byArray[n2] = (byte)(by ^ 0x80);
                    ++n2;
                }
            }
        }
        n2 = n9 / n4;
        this.updateCurrentFrame(n2);
        if (this.filterFlag) {
            this.slopeData(byArray);
        }
        return n2;
    }

    void slopeData(byte[] byArray) {
        int n = this.fout.getChannels();
        int n2 = this.fout.getSampleRate();
        float f = (float)n2 / 2.0f;
        if (n > 1) {
            if (this.DEBUG) {
                System.out.println("slopeData() number channels > 1");
            }
            return;
        }
        if (this.filterCutoffFreq >= f) {
            if (this.DEBUG) {
                System.out.println("slopeData() freqCutoff " + this.filterCutoffFreq + " higher than effective sample rate " + f);
            }
            return;
        }
        if ((double)this.filterCutoffFreq <= 20.0) {
            if (this.DEBUG) {
                System.out.println("slopeData() freqCutoff is below hearing");
            }
            return;
        }
        float f2 = f;
        int n3 = 1;
        int n4 = this.fout.getSampleSize();
        int n5 = 0;
        while (f2 > 20.0f) {
            f2 = f / (float)(n3 + 1);
            if (this.filterCutoffFreq >= f2) {
                int n6 = byArray.length;
                if (this.DEBUG) {
                    System.out.println("slopeData(), offset chosen = " + n3);
                    System.out.println("              sampleSize = " + n4 + ", numChannels = " + n);
                    if (n6 > 2) {
                        System.out.println("              data[] = " + byArray[0] + ", " + byArray[1] + ",...," + byArray[n6 - 2] + ", " + byArray[n6 - 1]);
                    }
                }
                int n7 = 0;
                if (this.DEBUG) {
                    System.out.println("slopeData(): Loop - offset, count = " + n3 + ", " + (n6 - 2 * (n3 + 1)) + "  ***************************");
                }
                int n8 = 0;
                int n9 = 0;
                while (n9 < n6 - 2 * (n3 + 1)) {
                    if (n7 > 0 && n7 <= n3) {
                        if (this.DEBUG) {
                            System.out.println("slopeData(): old value " + n9 + " = " + Integer.toHexString(byArray[n9]) + ", " + Integer.toHexString(byArray[n9 + 1]));
                        }
                        n8 += n5;
                        if (this.DEBUG) {
                            System.out.println("slopeData(): delta added to int " + Integer.toHexString(n5) + ", " + Integer.toHexString(n8));
                        }
                        byArray[n9] = (byte)(n8 >>> 8);
                        byArray[n9 + 1] = (byte)(n8 & 0xFF);
                    } else {
                        if (this.DEBUG) {
                            System.out.println("slopeData(): unchanged value " + n9 + " = " + Integer.toHexString(byArray[n9]) + ", " + Integer.toHexString(byArray[n9 + 1]));
                        }
                        int n10 = byArray[n9];
                        n10 = n10 << 8 | byArray[n9 + 1] & 0xFF;
                        if (this.DEBUG) {
                            System.out.println("slopeData(): data left " + Integer.toHexString(n10));
                        }
                        int n11 = byArray[n9 + 2 * (n3 + 1)];
                        n11 = n11 << 8 | byArray[n9 + 2 * (n3 + 1) + 1] & 0xFF;
                        if (this.DEBUG) {
                            System.out.println("slopeData(): data right " + Integer.toHexString(n11));
                        }
                        n5 = (int)(0.5f + (float)(n11 - n10) / (float)(n3 + 1));
                        n8 = n10;
                        if (this.DEBUG) {
                            System.out.println("slopeData(): delta " + Integer.toHexString(n5));
                        }
                        n7 = 0;
                    }
                    ++n7;
                    if (this.DEBUG) {
                        System.out.println("slopeData(): new value " + n9 + " = " + Integer.toHexString(byArray[n9]) + ", " + Integer.toHexString(byArray[n9 + 1]));
                    }
                    n9 += 2;
                }
                break;
            }
            ++n3;
        }
    }

    void setFiltering(boolean bl, float f) {
        if (this.DEBUG) {
            System.out.println("setFiltering(" + bl + ", " + f + ")");
        }
        this.filterFlag = bl;
        if (bl) {
            this.filterCutoffFreq = f;
        }
    }

    public Format[] getFormat() {
        Format[] formatArray = new Format[]{this.f};
        return formatArray;
    }

    int getTotalBytes() {
        return this.totalBytes;
    }

    int getTotalFrames() {
        return this.totalFrames;
    }

    int getCurrentFrame() {
        return this.currentFrame;
    }

    int getRemainingFrames() {
        return this.totalFrames - this.currentFrame;
    }

    void setCurrentFrame(int n) {
        this.currentFrame = n;
        if (n < this.getTotalFrames()) {
            this.streamFinished = false;
        }
    }

    protected void updateCurrentFrame(int n) {
        this.currentFrame += n;
        int n2 = this.getTotalFrames();
        if (n2 > 0 && this.currentFrame >= n2) {
            this.streamFinished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getBytes() {
        if (!(this.stream instanceof ByteArrayInputStream)) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)this.stream;
        byte[] byArray = null;
        InputStream inputStream = this.stream;
        synchronized (inputStream) {
            int n = byteArrayInputStream.available();
            byteArrayInputStream.reset();
            int n2 = byteArrayInputStream.available();
            byArray = new byte[n2];
            byteArrayInputStream.read(byArray, 0, byArray.length);
            byteArrayInputStream.reset();
            byteArrayInputStream.skip(n2 - n);
        }
        return byArray;
    }

    boolean setData() throws IOException {
        if (this.sharedInputContainers != null) {
            int n = this.sharedInputContainers.size() - 1;
            while (n >= 0) {
                AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)this.sharedInputContainers.get(n);
                if (audioContainerInputStream.cachedBuffer != null) {
                    this.cachedBuffer = audioContainerInputStream.cachedBuffer;
                    this.stream = new ByteArrayInputStream(this.cachedBuffer);
                    return true;
                }
                --n;
            }
        }
        return this.totalBytes > 0 ? this.readTotalBytes() : this.readAllBytes();
    }

    boolean readAllBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int n = 2048;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        if (this.stream instanceof ByteArrayInputStream) {
            return true;
        }
        try {
            while (true) {
                if ((n3 = this.in.read(byArray, 0, n)) == -1) {
                    if (n2 != 0) break;
                    this.totalBytes = 0;
                    return false;
                }
                dataOutputStream.write(byArray, 0, n3);
                n2 += n3;
                Thread.currentThread();
                Thread.yield();
            }
            this.in.close();
            this.cachedBuffer = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.totalBytes = 0;
            this.cachedBuffer = null;
            throw new IOException(iOException.getMessage());
        }
        this.totalBytes = n2;
        this.stream = new ByteArrayInputStream(this.cachedBuffer);
        return true;
    }

    boolean readTotalBytes() throws IOException {
        this.cachedBuffer = new byte[this.totalBytes];
        try {
            int n = this.readFully(this.cachedBuffer, 0, this.cachedBuffer.length);
            this.close();
        }
        catch (IOException iOException) {
            this.cachedBuffer = null;
            throw iOException;
        }
        this.stream = new ByteArrayInputStream(this.cachedBuffer);
        return true;
    }

    public long getDataPos() {
        return 0L;
    }

    boolean streamIsFinished() {
        return this.streamFinished;
    }

    protected AudioFormat readFormat(byte[] byArray) throws BadAudioHeaderException, IOException {
        throw new BadAudioHeaderException("cannot read format in ACIS base class");
    }

    static AudioContainerInputStream getStream(InputStream inputStream) throws IOException, BadAudioHeaderException {
        AudioContainerInputStream audioContainerInputStream;
        if (inputStream instanceof AudioContainerInputStream) {
            return (AudioContainerInputStream)inputStream;
        }
        if (inputStream instanceof AudioStream) {
            return ((AudioStream)inputStream).acis;
        }
        if (inputStream instanceof AudioDataStream) {
            return ((AudioDataStream)inputStream).acis;
        }
        if (inputStream instanceof NativeAudioStream) {
            return ((NativeAudioStream)inputStream).acis;
        }
        inputStream.mark(12);
        byte[] byArray = new byte[4];
        int n = inputStream.read(byArray);
        int n2 = (byArray[0] << 24) + (byArray[1] << 16) + (byArray[2] << 8) + (byArray[3] << 0);
        switch (n2) {
            case 1297377380: {
                audioContainerInputStream = new AudioMidiInputStream(byArray, inputStream);
                break;
            }
            case 1179603533: {
                audioContainerInputStream = new AudioAiffInputStream(byArray, inputStream);
                break;
            }
            case 1230128474: {
                audioContainerInputStream = new AudioRmfInputStream(byArray, inputStream);
                break;
            }
            case 6583086: 
            case 779314176: 
            case 779316836: 
            case 1684960046: {
                audioContainerInputStream = new AudioAuInputStream(byArray, inputStream);
                break;
            }
            case 1380533830: {
                byte[] byArray2 = new byte[12];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                n += inputStream.read(byArray2, n, 8);
                int n3 = (byArray2[8] << 24) + (byArray2[9] << 16) + (byArray2[10] << 8) + (byArray2[11] << 0);
                if (n3 == 1463899717) {
                    audioContainerInputStream = new AudioWavInputStream(byArray2, inputStream);
                    break;
                }
                byArray = byArray2;
            }
            default: {
                try {
                    inputStream.reset();
                    throw new BadAudioHeaderException("Unknown header");
                }
                catch (IOException iOException) {
                    throw new BadAudioHeaderException("Unknownheader", byArray);
                }
            }
        }
        return audioContainerInputStream;
    }

    byte[] ulawToLinear(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length * 2];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            byArray2[n2] = (byte)ULAW_TABH[byArray[n] & 0xFF];
            byArray2[n2 + 1] = (byte)ULAW_TABL[byArray[n] & 0xFF];
            ++n;
            n2 += 2;
        }
        return byArray2;
    }

    AudioFormat getInputFormat() {
        return this.f;
    }

    AudioFormat getOutputFormat() {
        return this.fout;
    }

    protected int rllong(DataInputStream dataInputStream) throws IOException {
        int n = 0;
        n = dataInputStream.readInt();
        int n2 = (n & 0xFF) << 24;
        int n3 = (n & 0xFF00) << 8;
        int n4 = (n & 0xFF0000) >> 8;
        int n5 = (n & 0xFF000000) >>> 24;
        n = n2 | n3 | n4 | n5;
        return n;
    }

    protected short rlshort(DataInputStream dataInputStream) throws IOException {
        short s = 0;
        s = dataInputStream.readShort();
        short s2 = (short)((s & 0xFF) << 8);
        short s3 = (short)((s & 0xFF00) >>> 8);
        s = (short)(s2 | s3);
        return s;
    }

    void setVerbose(boolean bl) {
        this.DEBUG = bl;
    }

    AudioContainerInputStream cloneInputStream() {
        return new AudioContainerInputStream(this);
    }

    boolean resetAudioInputStream() {
        if (this.cachedBuffer != null) {
            this.stream = new ByteArrayInputStream(this.cachedBuffer);
            return true;
        }
        if (this.sharedInputContainers != null) {
            int n = this.sharedInputContainers.size() - 1;
            while (n >= 0) {
                AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)this.sharedInputContainers.get(n);
                if (audioContainerInputStream.cachedBuffer != null) {
                    this.cachedBuffer = audioContainerInputStream.cachedBuffer;
                    this.stream = new ByteArrayInputStream(this.cachedBuffer);
                    return true;
                }
                --n;
            }
        }
        return false;
    }
}

