/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.headspace;

import com.sun.j3d.audioengines.headspace.AudioContainerInputStream;
import com.sun.j3d.audioengines.headspace.AudioMidiInputStream;
import com.sun.j3d.audioengines.headspace.AudioRmfInputStream;
import com.sun.j3d.audioengines.headspace.ContinuousAudioDataStream;
import com.sun.j3d.audioengines.headspace.HaeAudioStream;
import com.sun.j3d.audioengines.headspace.HaeDevice;
import com.sun.j3d.audioengines.headspace.HaeException;
import com.sun.j3d.audioengines.headspace.HaeMidiSong;
import com.sun.j3d.audioengines.headspace.HaeMixer;
import com.sun.j3d.audioengines.headspace.HaeNoise;
import com.sun.j3d.audioengines.headspace.HaeRmfSong;
import com.sun.j3d.audioengines.headspace.InvalidAudioFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;

class AudioDevice {
    private boolean DEBUG = false;
    private Hashtable clipStreams = new Hashtable();
    private boolean playing = false;
    private HaeMixer mixer = null;
    private int rate = 44;
    private int interpMode = 1;
    private int renderFlags = 3;
    static final AudioDevice device = new AudioDevice();

    private AudioDevice() {
    }

    synchronized void openChannel(InputStream inputStream) {
        block15: {
            AudioContainerInputStream audioContainerInputStream;
            if (this.clipStreams.get(inputStream) != null) {
                if (this.DEBUG) {
                    System.err.println("AudioDevice.openChannel(" + inputStream + "): channel already open");
                }
                return;
            }
            try {
                audioContainerInputStream = AudioContainerInputStream.getStream(inputStream);
            }
            catch (IOException iOException) {
                if (this.DEBUG) {
                    System.err.println("AudioDevice.openChannel(" + inputStream + "): could not create stream");
                }
                return;
            }
            try {
                HaeNoise haeNoise;
                if (audioContainerInputStream instanceof AudioRmfInputStream || audioContainerInputStream instanceof AudioMidiInputStream) {
                    HaeMidiSong haeMidiSong = audioContainerInputStream instanceof AudioRmfInputStream ? new HaeRmfSong(this.mixer) : new HaeMidiSong(this.mixer);
                    haeMidiSong.open(audioContainerInputStream.getBytes());
                    haeMidiSong.setLoopFlag(inputStream instanceof ContinuousAudioDataStream);
                    if (this.DEBUG) {
                        String string = inputStream instanceof ContinuousAudioDataStream ? "Will" : "Will not";
                        System.err.println(string + " loop this song.");
                    }
                    haeNoise = haeMidiSong;
                    if (this.clipStreams.size() == 0) {
                        this.rate = 22;
                    }
                } else {
                    try {
                        haeNoise = new HaeAudioStream(audioContainerInputStream, inputStream.toString());
                    }
                    catch (InvalidAudioFormatException invalidAudioFormatException) {
                        if (this.DEBUG) {
                            System.err.println("AudioDevice.openChannel(" + inputStream + "): could not create stream");
                        }
                        return;
                    }
                }
                this.open();
                if (this.playing) {
                    haeNoise.start();
                    this.clipStreams.put(inputStream, haeNoise);
                }
            }
            catch (HaeException haeException) {
                if (!this.DEBUG) break block15;
                System.err.println("AudioDevice: Problem opening an new stream: " + haeException);
            }
        }
        this.notify();
    }

    synchronized void closeChannel(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        HaeNoise haeNoise = (HaeNoise)this.clipStreams.remove(inputStream);
        if (haeNoise != null) {
            if (this.DEBUG) {
                System.out.println("AudioDevice.closeChannel(): retrieved and closing stream:\n\t" + inputStream);
            }
            haeNoise.close();
        } else if (this.DEBUG) {
            System.out.println("AudioDevice.closeChannel(): could not retrieve stream(" + inputStream + ")");
        }
        this.notify();
    }

    synchronized void open() {
        if (this.DEBUG) {
            System.out.println("AudioDevice.open(), playing = " + this.playing);
        }
        try {
            if (this.mixer == null) {
                this.mixer = HaeDevice.getSystemMixer();
            }
            this.mixer.reengageAudio();
            this.playing = true;
        }
        catch (HaeException haeException) {
            if (this.DEBUG) {
                System.out.println("Failed to open audio device.");
            }
            if (this.DEBUG) {
                System.out.println("HaeException opening device: " + haeException);
                haeException.printStackTrace();
            }
            this.closeStreams();
            this.playing = false;
        }
    }

    synchronized void close() {
        if (this.DEBUG) {
            System.err.println("Closing device.");
        }
        if (this.playing) {
            this.mixer.disengageAudio();
        }
        this.playing = false;
        this.notify();
    }

    private synchronized boolean waitForData() throws InterruptedException {
        if (this.clipStreams.size() == 0) {
            this.close();
            do {
                if (this.DEBUG) {
                    System.err.println("Waiting for updates.");
                }
                this.wait();
            } while (this.clipStreams.size() == 0);
            this.open();
            return true;
        }
        this.wait();
        return false;
    }

    void play() {
        while (this.playing) {
            try {
                this.waitForData();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.DEBUG) {
            System.out.println("exiting play()");
        }
    }

    synchronized void closeStreams() {
        if (this.DEBUG) {
            System.err.println("AudioDevice: Closing all streams.");
        }
        Enumeration enumeration = this.clipStreams.elements();
        Enumeration enumeration2 = this.clipStreams.keys();
        while (enumeration.hasMoreElements()) {
            ((HaeNoise)enumeration.nextElement()).close();
        }
        if (this.DEBUG) {
            System.err.println("Audio Device: Streams all closed.");
        }
        this.clipStreams = new Hashtable();
    }

    int openChannels() {
        return this.clipStreams.size();
    }

    void setVerbose(boolean bl) {
        this.DEBUG = bl;
    }
}

