/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.headspace;

import com.sun.j3d.audioengines.AuralParameters;
import com.sun.j3d.audioengines.headspace.HAESample;
import java.util.NoSuchElementException;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

class HAEPositionalSample
extends HAESample {
    protected static final boolean dopplerFlag = true;
    int secondIndex = -1;
    int reverbIndex = -1;
    Point3f xformLeftEar = new Point3f(-0.09f, -0.03f, 0.095f);
    Point3f xformRightEar = new Point3f(0.09f, -0.03f, 0.095f);
    Vector3f xformHeadZAxis = new Vector3f(0.0f, 0.0f, -1.0f);
    Vector3f sourceToCenterEar = new Vector3f();
    Vector3f sourceToRightEar = new Vector3f();
    Vector3f sourceToLeftEar = new Vector3f();
    boolean averageDistances = false;
    long deltaTime = 0L;
    double sourcePositionChange = -1.0;
    double headPositionChange = -1.0;
    static int MAX_DISTANCES = 4;
    int numDistances = 0;
    long[] times = new long[MAX_DISTANCES];
    Point3f[] positions = new Point3f[MAX_DISTANCES];
    Point3f[] centerEars = new Point3f[MAX_DISTANCES];
    int firstIndex = 0;
    int lastIndex = 0;
    int currentIndex = 0;
    double lastRequestedDopplerRateRatio = -1.0;
    double lastActualDopplerRateRatio = -1.0;
    static int TOWARDS = 1;
    static int NO_CHANGE = 0;
    static int AWAY = -1;
    boolean filterFlag = false;
    float filterFreq = -1.0f;

    HAEPositionalSample() {
        int n = 0;
        while (n < MAX_DISTANCES) {
            this.positions[n] = new Point3f();
            this.centerEars[n] = new Point3f(0.09f, -0.03f, 0.095f);
            ++n;
        }
        this.clear();
    }

    void setSecondIndex(int n) {
        this.secondIndex = n;
    }

    int getSecondIndex() {
        return this.secondIndex;
    }

    void setReverbIndex(int n) {
        this.reverbIndex = n;
    }

    int getReverbIndex() {
        return this.reverbIndex;
    }

    boolean getFilterFlag() {
        return this.filterFlag;
    }

    float getFilterFreq() {
        return this.filterFreq;
    }

    public void clear() {
        super.clear();
        this.xformLeftEar.set(-0.09f, -0.03f, 0.095f);
        this.xformRightEar.set(0.09f, -0.03f, 0.095f);
        this.xformHeadZAxis.set(0.0f, 0.0f, -1.0f);
        this.sourceToCenterEar.set(0.0f, 0.0f, 0.0f);
        this.sourceToRightEar.set(0.0f, 0.0f, 0.0f);
        this.sourceToLeftEar.set(0.0f, 0.0f, 0.0f);
        this.reset();
    }

    void reset() {
        super.reset();
        this.averageDistances = false;
        this.deltaTime = 0L;
        this.sourcePositionChange = -1.0;
        this.headPositionChange = -1.0;
        this.numDistances = 0;
        this.averageDistances = false;
    }

    void incrementIndices() {
        int n = MAX_DISTANCES - 1;
        if (this.numDistances < n) {
            this.averageDistances = false;
            this.currentIndex = this.numDistances++;
            this.lastIndex = this.currentIndex - 1;
            this.firstIndex = 0;
        } else if (this.numDistances == n) {
            this.averageDistances = true;
            this.currentIndex = n;
            this.lastIndex = this.currentIndex - 1;
            this.firstIndex = 0;
            ++this.numDistances;
        } else if (this.numDistances > n) {
            this.averageDistances = true;
            ++this.currentIndex;
            ++this.lastIndex;
            ++this.firstIndex;
            this.currentIndex %= MAX_DISTANCES;
            this.lastIndex %= MAX_DISTANCES;
            this.firstIndex %= MAX_DISTANCES;
        }
    }

    void setXformedPosition() {
        Point3f point3f = new Point3f();
        if (this.getVWrldXfrmFlag()) {
            this.vworldXfrm.transform(this.position, point3f);
        } else {
            point3f.set((Tuple3f)this.position);
        }
        if (point3f.x == this.positions[this.currentIndex].x && point3f.y == this.positions[this.currentIndex].y && point3f.z == this.positions[this.currentIndex].z) {
            return;
        }
        this.incrementIndices();
        this.times[this.currentIndex] = System.currentTimeMillis();
        this.positions[this.currentIndex].set((Tuple3f)point3f);
        if (this.numDistances > 1) {
            this.centerEars[this.currentIndex].set((Tuple3f)this.centerEars[this.lastIndex]);
        }
    }

    float calculateDoppler(AuralParameters auralParameters) {
        double d = 1.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        float f = 0.344f;
        double d6 = 1.0;
        double d7 = 1.0;
        int n = NO_CHANGE;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (!this.averageDistances) {
            this.debugPrint("HAEPositionalSample.calculateDoppler - not enough distance data collected, dopplerRatio set to zero");
            return 0.0f;
        }
        Point3f point3f = this.positions[this.lastIndex];
        Point3f point3f2 = this.centerEars[this.lastIndex];
        Point3f point3f3 = this.positions[this.currentIndex];
        Point3f point3f4 = this.centerEars[this.currentIndex];
        d4 = point3f3.distance(point3f4);
        d5 = point3f.distance(point3f2);
        this.debugPrint("HAEPositionalSample.calculateDoppler - distances: current,last = " + d4 + ", " + d5);
        this.debugPrint("                                      current position = " + point3f3.x + ", " + point3f3.y + ", " + point3f3.z);
        this.debugPrint("                                      current ear = " + point3f4.x + ", " + point3f4.y + ", " + point3f4.z);
        this.debugPrint("                                      last position = " + point3f.x + ", " + point3f.y + ", " + point3f.z);
        this.debugPrint("                                      last ear = " + point3f2.x + ", " + point3f2.y + ", " + point3f2.z);
        if (d4 == d5) {
            this.debugPrint("HAEPositionalSample.calculateDoppler - distance diff = 0, dopplerRatio set to zero");
            return 0.0f;
        }
        this.deltaTime = this.times[this.currentIndex] - this.times[this.firstIndex];
        int n2 = 0;
        while (n2 < MAX_DISTANCES - 1) {
            f2 += this.positions[n2 + 1].distance(this.positions[n2]);
            f3 += this.centerEars[n2 + 1].distance(this.centerEars[n2]);
            ++n2;
        }
        d3 = (f2 /= (float)(MAX_DISTANCES - 1)) / (float)this.deltaTime;
        d2 = (f3 /= (float)(MAX_DISTANCES - 1)) / (float)this.deltaTime;
        this.debugPrint("                                      delta time = " + this.deltaTime);
        this.debugPrint("                                      soundPosition delta = " + point3f3.distance(point3f));
        this.debugPrint("                                      soundVelocity = " + d3);
        this.debugPrint("                                      headPosition delta = " + point3f4.distance(point3f2));
        this.debugPrint("                                      headVelocity = " + d2);
        if (auralParameters != null) {
            float f4 = auralParameters.rolloff;
            float f5 = auralParameters.velocityScaleFactor;
            if (f4 != 1.0f) {
                f *= f4;
                this.debugPrint("                                      attrib rollof = " + f4);
            }
            if (f5 != 1.0f) {
                this.debugPrint("                                      attrib velocity scale factor = " + f5);
                this.debugPrint("                                      new soundVelocity = " + (d3 *= (double)f5));
                this.debugPrint("                                      new headVelocity = " + (d2 *= (double)f5));
            }
        }
        if (d4 < d5) {
            this.debugPrint("                                      moving towards...");
            n = TOWARDS;
            d6 = (double)f + d2;
            d7 = (double)f - d3;
        } else {
            this.debugPrint("                                      moving away...");
            n = AWAY;
            d6 = (double)f - d2;
            d7 = (double)f + d3;
        }
        if (d6 <= 0.0) {
            this.debugPrint("HAEPositionalSample.calculateDoppler: BOOM!! - velocity of head > speed of sound");
            return -1.0f;
        }
        if (d7 <= 0.0) {
            this.debugPrint("HAEPositionalSample.calculateDoppler: BOOM!! - velocity of sound source negative");
            return -1.0f;
        }
        this.debugPrint("HAEPositionalSample.calculateDoppler: numerator = " + d6 + ", denominator = " + d7);
        d = d6 / d7;
        return (float)d;
    }

    void updateEar(int n, View view) {
        Point3f point3f = new Point3f();
        if (!this.calculateNewEar(n, view, point3f)) {
            return;
        }
        if (point3f.x == this.centerEars[this.currentIndex].x && point3f.y == this.centerEars[this.currentIndex].y && point3f.z == this.centerEars[this.currentIndex].z) {
            return;
        }
        this.incrementIndices();
        this.times[this.currentIndex] = System.currentTimeMillis();
        this.centerEars[this.currentIndex].set((Tuple3f)point3f);
        if (this.numDistances > 1) {
            this.positions[this.currentIndex].set((Tuple3f)this.positions[this.lastIndex]);
        }
    }

    boolean calculateNewEar(int n, View view, Point3f point3f) {
        PhysicalBody physicalBody;
        Point3d point3d = new Point3d();
        boolean bl = false;
        if (!bl && view != null && (physicalBody = view.getPhysicalBody()) != null) {
            Transform3D transform3D = new Transform3D();
            try {
                view.getUserHeadToVworld(transform3D);
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (RestrictedAccessException restrictedAccessException) {
                // empty catch block
            }
            physicalBody.getLeftEarPosition(point3d);
            this.xformLeftEar.x = (float)point3d.x;
            this.xformLeftEar.y = (float)point3d.y;
            this.xformLeftEar.z = (float)point3d.z;
            physicalBody.getRightEarPosition(point3d);
            this.xformRightEar.x = (float)point3d.x;
            this.xformRightEar.y = (float)point3d.y;
            this.xformRightEar.z = (float)point3d.z;
            transform3D.transform(this.xformRightEar);
            transform3D.transform(this.xformLeftEar);
            this.xformHeadZAxis.set(0.0f, 0.0f, -1.0f);
            transform3D.transform(this.xformHeadZAxis);
            point3f.x = this.xformLeftEar.x + (this.xformRightEar.x - this.xformLeftEar.x) * 0.5f;
            point3f.y = this.xformLeftEar.y + (this.xformRightEar.y - this.xformLeftEar.y) * 0.5f;
            point3f.z = this.xformLeftEar.z + (this.xformRightEar.z - this.xformLeftEar.z) * 0.5f;
            bl = true;
        }
        if (!bl) {
            // empty if block
        }
        return bl;
    }

    public void render(int n, View view, AuralParameters auralParameters) {
        this.updateEar(n, view);
        float f = 1.0f;
        if (auralParameters != null) {
            float f2 = auralParameters.rolloff;
            float f3 = auralParameters.frequencyScaleFactor;
            float f4 = auralParameters.velocityScaleFactor;
            this.debugPrint("HAEPositionalSample: attribs NOT null");
            if (!(f2 <= 0.0f) && !(f3 <= 0.0f)) {
                if (f4 > 0.0f) {
                    this.debugPrint("    velocityScaleFactor = " + f4);
                    f = this.calculateDoppler(auralParameters);
                    if (f != 0.0f && f != -1.0f && f > 0.0f) {
                        this.setTargetRateRatio(f * f3 * this.rateScaleFactor);
                    }
                } else {
                    this.setTargetRateRatio(f3 * this.rateScaleFactor);
                }
            }
        } else {
            this.debugPrint("HAEPositionalSample: attribs null");
            this.setTargetRateRatio(this.rateScaleFactor);
        }
        this.panSample(auralParameters);
    }

    float calculateAngularGain() {
        return 1.0f;
    }

    void calculateFilter(float f, AuralParameters auralParameters) {
        float f2 = 44100.0f;
        float f3 = 44100.0f;
        int n = auralParameters.getDistanceFilterLength();
        int n2 = auralParameters.getDistanceFilterType();
        boolean bl = false;
        boolean bl2 = false;
        if (n2 != -1 && n > 0) {
            double[] dArray = new double[n];
            float[] fArray = new float[n];
            auralParameters.getDistanceFilter(dArray, fArray);
            f2 = this.findFactor(f, dArray, fArray);
            bl = !(f2 < 0.0f);
        } else {
            bl = false;
            f2 = -1.0f;
        }
        bl2 = false;
        f3 = -1.0f;
        this.filterFlag = bl || bl2;
        this.filterFreq = f2;
    }

    float findFactor(double d, double[] dArray, float[] fArray) {
        if (dArray == null || fArray == null) {
            return -1.0f;
        }
        int n = dArray.length;
        if (n < 2) {
            return -1.0f;
        }
        int n2 = n - 1;
        if (d >= dArray[n2]) {
            return fArray[n2];
        }
        if (d <= dArray[0]) {
            return fArray[0];
        }
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4 - 1) {
            if (dArray[n3] >= d) {
                if (d < dArray[n3]) {
                    // empty if block
                }
                return fArray[n3];
            }
            if (dArray[n4] <= d) {
                if (d > dArray[n4]) {
                    // empty if block
                }
                return fArray[n4];
            }
            if (!(d > dArray[n3]) || !(d < dArray[n4])) continue;
            int n5 = n3 + (n4 - n3) / 2;
            if (d <= dArray[n5]) {
                n4 = n5;
                continue;
            }
            n3 = n5;
        }
        float f = (float)((d - dArray[n3]) / (dArray[n4] - dArray[n3])) * (fArray[n4] - fArray[n3]) + fArray[n3];
        return f;
    }

    float calculateDistanceAttenuation(float f) {
        float f2 = 1.0f;
        f2 = this.findFactor(f, this.attenuationDistance, this.attenuationGain);
        if ((double)f2 >= 0.0) {
            return f2;
        }
        return 1.0f;
    }

    void panSample(AuralParameters auralParameters) {
        int n = 1;
        float f = 1.0f;
        float f2 = 0.125f;
        float f3 = f - f2;
        float f4 = 1.0E-6f;
        float f5 = 0.999999f;
        float f6 = -f5;
        float f7 = 1.5707964f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.18f;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        float f16 = 0.0f;
        float f17 = 0.0f;
        float f18 = 0.344f;
        float f19 = 1.0f / 0.344f;
        float f20 = 44.1f;
        boolean bl = false;
        boolean bl2 = false;
        float f21 = 1.0f;
        float f22 = this.gain;
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f();
        Vector3f vector3f = new Vector3f();
        point3f.set((Tuple3f)this.positions[this.currentIndex]);
        point3f2.set((Tuple3f)this.centerEars[this.currentIndex]);
        this.sourceToCenterEar.x = point3f2.x - point3f.x;
        this.sourceToCenterEar.y = point3f2.y - point3f.y;
        this.sourceToCenterEar.z = point3f2.z - point3f.z;
        this.sourceToRightEar.x = this.xformRightEar.x - point3f.x;
        this.sourceToRightEar.y = this.xformRightEar.y - point3f.y;
        this.sourceToRightEar.z = this.xformRightEar.z - point3f.z;
        this.sourceToLeftEar.x = this.xformLeftEar.x - point3f.x;
        this.sourceToLeftEar.y = this.xformLeftEar.y - point3f.y;
        this.sourceToLeftEar.z = this.xformLeftEar.z - point3f.z;
        f8 = point3f.distance(point3f2);
        f10 = point3f.distance(this.xformRightEar);
        f11 = point3f.distance(this.xformLeftEar);
        f12 = this.xformRightEar.distance(this.xformLeftEar);
        f13 = f12 * 0.5f;
        f14 = f13 / f8;
        double d = this.sourceToCenterEar.dot(this.xformHeadZAxis) / (this.sourceToCenterEar.length() * this.xformHeadZAxis.length());
        f15 = (float)Math.acos(d);
        if (f15 > f7) {
            bl2 = true;
            f15 = (float)Math.PI - f15;
        } else {
            bl2 = false;
        }
        f17 = (float)Math.acos(f14);
        boolean bl3 = bl = !(f10 > f11);
        n = bl ? (bl2 ? 4 : 1) : (bl2 ? 3 : 2);
        f16 = (float)Math.sin(f15);
        if ((double)f16 < 0.0) {
            f16 = -f16;
        }
        float f23 = (float)Math.sqrt((double)f8 * (double)f8 + (double)(f13 * f13));
        if (bl) {
            f11 = f23 + f13 * (f7 + f15 - f17);
        } else {
            f10 = f23 + f13 * (f7 + f15 - f17);
        }
        if (f16 < f14) {
            if (bl) {
                f10 = f23 + f13 * (f7 - f15 - f17);
            } else {
                f11 = f23 + f13 * (f7 - f15 - f17);
            }
        } else if (bl) {
            // empty if block
        }
        f20 = (float)this.rate * 0.001f;
        if (bl) {
            this.rightDelay = 0;
            this.leftDelay = (int)((f11 - f10) * f19 * f20);
        } else {
            this.leftDelay = 0;
            this.rightDelay = (int)((f10 - f11) * f19 * f20);
        }
        point3f.sub((Tuple3f)point3f2);
        point3f.scale(1.0f / f8);
        f21 = this.calculateDistanceAttenuation(f8);
        f22 *= f21;
        f22 *= this.calculateAngularGain();
        float f24 = point3f.x / 2.0f;
        float f25 = f24 >= 0.0f ? f3 * (0.5f - f24) : f3 * (0.5f + f24);
        switch (n) {
            case 1: 
            case 4: {
                this.rightGain = f22 * (f - f25);
                this.leftGain = f22 * (f2 + f25);
                break;
            }
            case 2: 
            case 3: {
                this.leftGain = f22 * (f - f25);
                this.rightGain = f22 * (f2 + f25);
            }
        }
        this.calculateFilter(f8, auralParameters);
    }
}

