/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.headspace;

import com.sun.j3d.audioengines.AuralParameters;
import com.sun.j3d.audioengines.Sample;
import javax.media.j3d.View;

class HAESample
extends Sample {
    static final int STREAMING_AUDIO_DATA = 1;
    static final int BUFFERED_AUDIO_DATA = 2;
    static final int STREAMING_MIDI_DATA = 3;
    static final int BUFFERED_MIDI_DATA = 3;
    static final int UNSUPPORTED_DATA_TYPE = -1;
    static final int NULL_SAMPLE = -1;
    int dataType = 2;
    long dataOffset = 0L;
    float leftGain = 1.0f;
    float rightGain = 1.0f;
    int leftDelay = 0;
    int rightDelay = 0;
    long timeDeactivated = 0L;
    long positionDeactivated = 0L;
    long sampleLength = 0L;
    long loopStartOffset = 0L;
    long loopLength = 0L;
    long attackLength = 0L;
    long releaseLength = 0L;
    int rate = -1;
    float currentRateRatio = 1.0f;
    float targetRateRatio = 1.0f;
    boolean rampRateFlag = false;

    HAESample() {
    }

    void setDataType(int n) {
        this.dataType = n;
    }

    int getDataType() {
        return this.dataType;
    }

    public void clear() {
        super.clear();
        this.dataOffset = 0L;
        this.leftGain = 1.0f;
        this.rightGain = 1.0f;
        this.leftDelay = 0;
        this.rightDelay = 0;
        this.timeDeactivated = 0L;
        this.positionDeactivated = 0L;
        this.sampleLength = 0L;
        this.loopStartOffset = 0L;
        this.loopLength = 0L;
        this.attackLength = 0L;
        this.releaseLength = 0L;
        this.rate = -1;
    }

    void reset() {
        this.setTargetRateRatio(this.rateScaleFactor);
    }

    public void setGain(float f) {
        this.gain = f;
        this.leftGain = f;
        this.rightGain = f;
    }

    void setRate(int n) {
        this.rate = n;
    }

    int getRate() {
        return this.rate;
    }

    public void render(int n, View view, AuralParameters auralParameters) {
        this.leftGain = this.gain;
        this.rightGain = this.gain;
        this.leftDelay = 0;
        this.rightDelay = 0;
        if (auralParameters != null) {
            float f = auralParameters.frequencyScaleFactor;
            if (!(f <= 0.0f)) {
                this.setTargetRateRatio(this.rateScaleFactor * f);
            }
        } else {
            this.setTargetRateRatio(this.rateScaleFactor);
        }
    }

    int getReverbIndex() {
        return -1;
    }

    boolean getFilterFlag() {
        return false;
    }

    float getFilterFreq() {
        return -1.0f;
    }

    synchronized void setCurrentRateRatio(float f) {
        this.currentRateRatio = f;
    }

    synchronized float getCurrentRateRatio() {
        return this.currentRateRatio;
    }

    synchronized void setTargetRateRatio(float f) {
        this.targetRateRatio = f;
    }

    synchronized float getTargetRateRatio() {
        return this.targetRateRatio;
    }

    synchronized void setRampRateFlag(boolean bl) {
        this.rampRateFlag = bl;
    }

    synchronized boolean getRampRateFlag() {
        return this.rampRateFlag;
    }
}

