/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.headspace;

import com.sun.j3d.audioengines.headspace.HaeException;
import com.sun.j3d.audioengines.headspace.HaeMixer;
import com.sun.j3d.audioengines.headspace.HaeWaveNoise;
import com.sun.j3d.audioengines.headspace.HaeWaveStreamBuffer;

abstract class HaeWaveStream
extends HaeWaveNoise {
    protected static final int DEFAULT_TRANSFER_SIZE = 16384;
    protected int m_transferSize;
    protected long m_samplesSubmitted;
    private int m_bufferBytes;
    private HaeWaveStreamBuffer m_buffer = null;
    protected boolean m_done;
    private long m_streamSamplesPlayedAtStreamEnd;
    private long m_engineSamplesPlayedAtStreamEnd;

    public HaeWaveStream(HaeMixer haeMixer) {
        super(haeMixer);
        this.m_transferSize = 16384;
        this.m_samplesSubmitted = 0L;
        this.m_done = false;
    }

    public HaeWaveStream(HaeMixer haeMixer, int n, int n2, int n3, double d) throws HaeException {
        super(haeMixer);
        this.m_samplesSubmitted = 0L;
        this.m_done = false;
        this.open(n, n2, n3, d);
    }

    public void open(int n, int n2, int n3, double d) throws HaeException {
        this.close();
        int n4 = 512;
        while (n4 < n) {
            n4 *= 2;
        }
        if (n - n4 / 2 < n4 - n) {
            n4 /= 2;
        }
        this.m_bufferBytes = n4;
        this.setSampleInfo(d, n2, n3);
        this.m_buffer = new HaeWaveStreamBuffer(this.getBytesPerFrame());
        this.nativeOpen(this.getSampleRate(), n2, n3, this.getBytesPerFrame(), n4);
    }

    public void close() {
        this.stop(false);
    }

    public native void throwOnLastError() throws HaeException;

    public int getTransferSize() {
        return this.m_transferSize;
    }

    public void setTransferSize(int n) {
        this.m_transferSize = n;
    }

    public long getSamplesPlayed() {
        if (!this.m_done) {
            long l = this.privateGetSamplesPlayed();
            return l;
        }
        long l = (long)((float)(this.getMixer().getSamplesPlayed() - this.m_engineSamplesPlayedAtStreamEnd) * ((float)this.getSampleRate() / (float)this.getMixer().getOutputFormat().getSampleRate()));
        long l2 = Math.min(this.m_samplesSubmitted, this.m_streamSamplesPlayedAtStreamEnd + l);
        return l2;
    }

    public synchronized native void stop(boolean var1);

    public native void setVolume(double var1);

    public native void setPan(double var1);

    public native void drain();

    public native void flush();

    public native void pause();

    public native void resume();

    public native boolean isPlaying();

    public native double getVolume();

    public native double getPan();

    public int getBufferBytes() {
        return this.m_bufferBytes;
    }

    protected synchronized native void privateStart(double var1, double var3, boolean var5);

    protected native void privateSetSampleRate(double var1);

    protected native void privateSetReverb(boolean var1);

    protected abstract boolean getWavedata(HaeWaveStreamBuffer var1, int var2);

    protected void streamingFinished() {
        this.m_streamSamplesPlayedAtStreamEnd = this.getSamplesPlayed();
        this.m_engineSamplesPlayedAtStreamEnd = this.getMixer().getSamplesPlayed();
        this.m_done = true;
    }

    protected native long privateGetSamplesPlayed();

    protected synchronized native void nativeOpen(double var1, int var3, int var4, int var5, int var6) throws HaeException;

    protected boolean privateGetWavedata(int n) {
        return this.getWavedata(this.m_buffer, n);
    }
}

