/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.headspace;

import com.sun.j3d.audioengines.AudioEngine3DL2;
import com.sun.j3d.audioengines.AuralParameters;
import com.sun.j3d.audioengines.headspace.HAEDirectionalSample;
import com.sun.j3d.audioengines.headspace.HAEPositionalSample;
import com.sun.j3d.audioengines.headspace.HAESample;
import com.sun.j3d.audioengines.headspace.HeadspaceThread;
import com.sun.j3d.audioengines.headspace.J3DHaeClip;
import com.sun.j3d.audioengines.headspace.J3DHaeMidi;
import com.sun.j3d.audioengines.headspace.J3DHaeStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class HeadspaceMixer
extends AudioEngine3DL2 {
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;
    static final int ADD_TO_LIST = 1;
    static final int SET_INTO_LIST = 2;
    static int REFLECTION_COEFF_CHANGED = 1;
    static int REVERB_DELAY_CHANGED = 2;
    static int REVERB_ORDER_CHANGED = 4;
    int reverbDirty = 65535;
    boolean reverbOn = false;
    int reverbType = 1;
    HeadspaceThread thread = new HeadspaceThread(Thread.currentThread().getThreadGroup(), this);
    protected float deviceGain = 1.0f;
    protected static final int NOT_PAUSED = 0;
    protected static final int PAUSE_PENDING = 1;
    protected static final int PAUSED = 2;
    protected static final int RESUME_PENDING = 3;
    protected int pause = 0;

    void debugPrint(String string) {
    }

    void debugPrintln(String string) {
    }

    public HeadspaceMixer(PhysicalEnvironment physicalEnvironment) {
        super(physicalEnvironment);
    }

    public int getTotalChannels() {
        return J3DHaeStream.getTotalChannels();
    }

    public boolean initialize() {
        if (!J3DHaeStream.initialize()) {
            return false;
        }
        this.thread.initialize();
        return true;
    }

    public boolean close() {
        return J3DHaeStream.close();
    }

    int loadSound(MediaContainer mediaContainer) {
        int n = -1;
        int n2 = -1;
        String string = mediaContainer.getURLString();
        URL uRL = mediaContainer.getURLObject();
        InputStream inputStream = mediaContainer.getInputStream();
        boolean bl = mediaContainer.getCacheEnable();
        if (uRL != null) {
            n = J3DHaeStream.initAudioContainer(uRL, bl);
        } else if (string != null) {
            try {
                uRL = new URL(string);
            }
            catch (Exception exception) {
                return -1;
            }
            n = J3DHaeStream.initAudioContainer(uRL, bl);
        } else if (inputStream != null) {
            n = J3DHaeStream.initAudioContainer(inputStream, bl);
        }
        if (n == -1) {
            return -1;
        }
        if (n < 0) {
            return -1;
        }
        n2 = J3DHaeStream.getDataType(n);
        if (n2 == -1) {
            return -1;
        }
        int n3 = n2 == 2 ? (inputStream != null ? J3DHaeClip.loadSample(inputStream, n) : J3DHaeClip.loadSample(uRL, n)) : (n2 == 1 ? (inputStream != null ? J3DHaeStream.loadSample(inputStream, n) : J3DHaeStream.loadSample(uRL, n)) : (inputStream != null ? -1 : J3DHaeMidi.loadSample(uRL, n)));
        if (n3 < 0) {
            return -1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepareSound(int n, MediaContainer mediaContainer) {
        int n2;
        int n3;
        HAESample hAESample;
        int n4;
        block26: {
            n4 = -1;
            if (mediaContainer == null) {
                n4 = this.loadSound(null);
                return n4;
            }
            hAESample = null;
            HAEPositionalSample hAEPositionalSample = null;
            HAEDirectionalSample hAEDirectionalSample = null;
            int n5 = 1;
            n4 = this.loadSound(mediaContainer);
            n3 = J3DHaeStream.getDataType(n4);
            if (n3 == -1) {
                return -1;
            }
            ArrayList arrayList = this.samples;
            synchronized (arrayList) {
                int n6;
                int n7;
                block25: {
                    n2 = this.samples.size();
                    if (n4 >= n2) {
                        this.samples.ensureCapacity(n4 + 1);
                        n5 = 1;
                        n7 = n2;
                        while (n7 < n4) {
                            this.samples.add(n7, null);
                            ++n7;
                        }
                    } else {
                        n5 = 2;
                    }
                    if (n == 3) {
                        hAEDirectionalSample = new HAEDirectionalSample();
                        if (n5 == 2) {
                            this.samples.set(n4, hAEDirectionalSample);
                        } else {
                            this.samples.add(n4, hAEDirectionalSample);
                        }
                        hAESample = hAEDirectionalSample;
                        hAEPositionalSample = hAEDirectionalSample;
                    } else if (n == 2) {
                        hAEPositionalSample = new HAEPositionalSample();
                        if (n5 == 2) {
                            this.samples.set(n4, hAEPositionalSample);
                        } else {
                            this.samples.add(n4, hAEPositionalSample);
                        }
                        hAESample = hAEPositionalSample;
                    } else {
                        hAESample = new HAESample();
                        if (n5 == 2) {
                            this.samples.set(n4, hAESample);
                        } else {
                            this.samples.add(n4, hAESample);
                        }
                    }
                    if (hAEPositionalSample == null || n3 == 3 || n3 == 3) break block26;
                    n7 = -1;
                    n6 = -1;
                    n7 = this.loadSound(mediaContainer);
                    n6 = this.loadSound(mediaContainer);
                    if (n7 != -1 && n6 != -1) break block25;
                    this.clearSound(n4);
                    if (n7 != -1) {
                        this.clearSound(n7);
                    }
                    this.samples.set(n4, null);
                    int n8 = -1;
                    return n8;
                }
                int n9 = -1;
                n9 = n7 < n6 ? n6 : n7;
                int n10 = this.samples.size();
                if (n9 >= n10) {
                    this.samples.ensureCapacity(n9 + 1);
                }
                if (n7 >= n10) {
                    n5 = 1;
                    this.samples.add(n7, hAESample);
                } else {
                    n5 = 2;
                    this.samples.set(n7, hAESample);
                }
                hAEPositionalSample.setSecondIndex(n7);
                if (n6 >= n10) {
                    n5 = 1;
                    this.samples.add(n6, hAESample);
                } else {
                    n5 = 2;
                    this.samples.set(n6, hAESample);
                }
                hAEPositionalSample.setReverbIndex(n6);
            }
        }
        hAESample.setDirtyFlags(65535);
        hAESample.setSoundType(n);
        hAESample.setSoundData(mediaContainer);
        n2 = J3DHaeStream.getSampleRate(n4);
        hAESample.setRate(n2);
        hAESample.setDataType(n3);
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSound(int n) {
        HAESample hAESample = null;
        hAESample = (HAESample)this.getSample(n);
        if (hAESample == null) {
            return;
        }
        hAESample.clear();
        ArrayList arrayList = this.samples;
        synchronized (arrayList) {
            this.samples.set(n, null);
        }
    }

    public void setVworldXfrm(int n, Transform3D transform3D) {
        super.setVworldXfrm(n, transform3D);
        HAESample hAESample = null;
        hAESample = (HAESample)this.getSample(n);
        if (hAESample == null) {
            return;
        }
        int n2 = hAESample.getSoundType();
        if (n2 == 3) {
            HAEDirectionalSample hAEDirectionalSample = null;
            hAEDirectionalSample = (HAEDirectionalSample)this.getSample(n);
            if (hAEDirectionalSample == null) {
                return;
            }
            hAEDirectionalSample.setXformedDirection();
            hAEDirectionalSample.setXformedPosition();
            hAEDirectionalSample.setVWrldXfrmFlag(true);
        } else if (n2 == 2) {
            HAEPositionalSample hAEPositionalSample = null;
            hAEPositionalSample = (HAEPositionalSample)this.getSample(n);
            if (hAEPositionalSample == null) {
                return;
            }
            hAEPositionalSample.setXformedPosition();
            hAEPositionalSample.setVWrldXfrmFlag(true);
        }
    }

    public void setPosition(int n, Point3d point3d) {
        super.setPosition(n, point3d);
        HAEPositionalSample hAEPositionalSample = null;
        hAEPositionalSample = (HAEPositionalSample)this.getSample(n);
        if (hAEPositionalSample == null) {
            return;
        }
        int n2 = hAEPositionalSample.getSoundType();
        if (n2 == 2 || n2 == 3) {
            hAEPositionalSample.setXformedPosition();
        }
    }

    public void setDirection(int n, Vector3d vector3d) {
        super.setDirection(n, vector3d);
        HAEDirectionalSample hAEDirectionalSample = null;
        hAEDirectionalSample = (HAEDirectionalSample)this.getSample(n);
        if (hAEDirectionalSample == null) {
            return;
        }
        int n2 = hAEDirectionalSample.getSoundType();
        if (n2 == 3) {
            hAEDirectionalSample.setXformedDirection();
        }
    }

    public void setReflectionCoefficient(float f) {
        super.setReflectionCoefficient(f);
        this.reverbDirty |= REFLECTION_COEFF_CHANGED;
    }

    public void setReverbDelay(float f) {
        super.setReverbDelay(f);
        this.reverbDirty |= REVERB_DELAY_CHANGED;
    }

    public void setReverbOrder(int n) {
        super.setReverbOrder(n);
        this.reverbDirty |= REVERB_ORDER_CHANGED;
    }

    public int startSample(int n) {
        int n2 = -1;
        HAESample hAESample = null;
        hAESample = (HAESample)this.getSample(n);
        if (hAESample == null || this.thread == null) {
            return -1;
        }
        AuralParameters auralParameters = this.getAuralParameters();
        int n3 = hAESample.getSoundType();
        boolean bl = hAESample.getMuteFlag();
        if (bl) {
            hAESample.setLoopCount(0);
            hAESample.leftGain = 0.0f;
            hAESample.rightGain = 0.0f;
            hAESample.leftDelay = 0;
            hAESample.rightDelay = 0;
            if (n3 != 1) {
                this.setFilter(n, false, -1.0f);
            }
        } else {
            hAESample.render(hAESample.getDirtyFlags(), this.getView(), auralParameters);
            if (n3 != 1) {
                this.setFilter(n, hAESample.getFilterFlag(), hAESample.getFilterFreq());
            }
        }
        int n4 = hAESample.getDataType();
        int n5 = hAESample.getLoopCount();
        float f = hAESample.leftGain;
        float f2 = hAESample.rightGain;
        int n6 = (int)((float)hAESample.leftDelay * auralParameters.rolloff);
        int n7 = (int)((float)hAESample.rightDelay * auralParameters.rolloff);
        if (n4 == 1) {
            if (n3 == 1) {
                n2 = J3DHaeStream.startSample(n, n5, f);
                this.scaleSampleRate(n, true);
            } else {
                int n8 = ((HAEPositionalSample)hAESample).getSecondIndex();
                n2 = J3DHaeStream.startSamples(n, n8, n5, f, f2, n6, n7);
                this.scaleSampleRate(n, true);
                this.scaleSampleRate(n8, true);
                float f3 = 0.0f;
                if (!bl && this.reverbOn) {
                    f3 = hAESample.getGain() * auralParameters.reflectionCoefficient;
                }
                int n9 = ((HAEPositionalSample)hAESample).getReverbIndex();
                int n10 = J3DHaeStream.startSample(n9, n5, f3);
                this.scaleSampleRate(n9, true);
            }
        } else if (n4 == 2) {
            if (n3 == 1) {
                n2 = J3DHaeClip.startSample(n, n5, f);
                this.scaleSampleRate(n, true);
            } else {
                int n11 = ((HAEPositionalSample)hAESample).getSecondIndex();
                n2 = J3DHaeClip.startSamples(n, n11, n5, f, f2, n6, n7);
                this.scaleSampleRate(n, true);
                this.scaleSampleRate(n11, true);
                float f4 = 0.0f;
                if (!bl && this.reverbOn) {
                    f4 = hAESample.getGain() * auralParameters.reflectionCoefficient;
                }
                int n12 = ((HAEPositionalSample)hAESample).getReverbIndex();
                int n13 = J3DHaeClip.startSample(n12, n5, f4);
                this.scaleSampleRate(n12, true);
            }
        } else if (n4 == 3 || n4 == 3) {
            if (n3 == 1) {
                n2 = J3DHaeMidi.startSample(n, n5, f);
                this.scaleSampleRate(n, true);
            } else {
                int n14 = ((HAEPositionalSample)hAESample).getSecondIndex();
                n2 = J3DHaeMidi.startSamples(n, n14, n5, f, f2, n6, n7);
                this.scaleSampleRate(n, true);
                this.scaleSampleRate(n14, true);
            }
        } else {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (!bl) {
            if (this.reverbDirty > 0) {
                this.calcReverb(auralParameters);
            }
            this.setReverb(n);
        }
        return n2;
    }

    public int stopSample(int n) {
        HAESample hAESample = null;
        hAESample = (HAESample)this.getSample(n);
        if (hAESample == null) {
            return -1;
        }
        int n2 = hAESample.getDataType();
        int n3 = hAESample.getSoundType();
        int n4 = 0;
        if (n2 == 1) {
            if (n3 == 3 || n3 == 2) {
                n4 = J3DHaeStream.stopSamples(n, ((HAEPositionalSample)hAESample).getSecondIndex());
                n4 = J3DHaeStream.stopSample(((HAEPositionalSample)hAESample).getReverbIndex());
            } else {
                n4 = J3DHaeStream.stopSample(n);
            }
        } else if (n2 == 2) {
            if (n3 == 3 || n3 == 2) {
                n4 = J3DHaeClip.stopSamples(n, ((HAEPositionalSample)hAESample).getSecondIndex());
                n4 = J3DHaeClip.stopSample(((HAEPositionalSample)hAESample).getReverbIndex());
            } else {
                n4 = J3DHaeClip.stopSample(n);
            }
        } else if (n2 == 3 || n2 == 3) {
            n4 = J3DHaeMidi.stopSample(n);
        } else {
            return -1;
        }
        if (n4 < 0) {
            return -1;
        }
        hAESample.reset();
        return 0;
    }

    public void pauseSample(int n) {
        HAESample hAESample = null;
        hAESample = (HAESample)this.getSample(n);
        if (hAESample == null) {
            return;
        }
        int n2 = hAESample.getDataType();
        int n3 = hAESample.getSoundType();
        int n4 = 0;
        if (n2 == 1) {
            if (n3 == 3 || n3 == 2) {
                n4 = J3DHaeStream.pauseSamples(n, ((HAEPositionalSample)hAESample).getSecondIndex());
                n4 = J3DHaeStream.pauseSample(((HAEPositionalSample)hAESample).getReverbIndex());
            } else {
                n4 = J3DHaeStream.pauseSample(n);
            }
        } else if (n2 == 2) {
            if (n3 == 3 || n3 == 2) {
                n4 = J3DHaeClip.pauseSamples(n, ((HAEPositionalSample)hAESample).getSecondIndex());
                n4 = J3DHaeClip.pauseSample(((HAEPositionalSample)hAESample).getReverbIndex());
            } else {
                n4 = J3DHaeClip.pauseSample(n);
            }
        } else if (n2 == 3 || n2 == 3) {
            n4 = J3DHaeMidi.pauseSample(n);
        }
        if (n4 < 0) {
            // empty if block
        }
    }

    public void unpauseSample(int n) {
        HAESample hAESample = null;
        hAESample = (HAESample)this.getSample(n);
        if (hAESample == null) {
            return;
        }
        int n2 = hAESample.getDataType();
        int n3 = hAESample.getSoundType();
        int n4 = 0;
        if (n2 == 1) {
            if (n3 == 3 || n3 == 2) {
                n4 = J3DHaeStream.unpauseSamples(n, ((HAEPositionalSample)hAESample).getSecondIndex());
                n4 = J3DHaeStream.unpauseSample(((HAEPositionalSample)hAESample).getReverbIndex());
            } else {
                n4 = J3DHaeStream.unpauseSample(n);
            }
        } else if (n2 == 2) {
            if (n3 == 3 || n3 == 2) {
                n4 = J3DHaeClip.unpauseSamples(n, ((HAEPositionalSample)hAESample).getSecondIndex());
                n4 = J3DHaeClip.unpauseSample(((HAEPositionalSample)hAESample).getReverbIndex());
            } else {
                n4 = J3DHaeClip.unpauseSample(n);
            }
        } else if (n2 == 3 || n2 == 3) {
            n4 = J3DHaeMidi.unpauseSample(n);
        }
        if (n4 < 0) {
            // empty if block
        }
    }

    public void updateSample(int n) {
        HAESample hAESample = null;
        hAESample = (HAESample)this.getSample(n);
        if (hAESample == null || this.thread == null) {
            return;
        }
        int n2 = hAESample.getLoopCount();
        int n3 = hAESample.getSoundType();
        boolean bl = hAESample.getMuteFlag();
        if (bl) {
            float f = hAESample.leftGain;
            float f2 = hAESample.rightGain;
            if (f != 0.0f || f2 != 0.0f) {
                hAESample.rightGain = 0.0f;
                hAESample.leftGain = 0.0f;
                this.setStereoGain(n, 0.0f, 0.0f);
            }
            if (n3 != 1) {
                this.setFilter(n, false, -1.0f);
            }
        } else {
            AuralParameters auralParameters = this.getAuralParameters();
            if (this.reverbDirty > 0) {
                this.calcReverb(auralParameters);
            }
            this.setReverb(n);
            hAESample.render(hAESample.getDirtyFlags(), this.getView(), auralParameters);
            this.scaleSampleRate(n, false);
            if (n3 != 1) {
                this.setFilter(n, hAESample.getFilterFlag(), hAESample.getFilterFreq());
            }
            float f = hAESample.leftGain;
            float f3 = hAESample.rightGain;
            int n4 = (int)((float)hAESample.leftDelay * auralParameters.rolloff);
            int n5 = (int)((float)hAESample.rightDelay * auralParameters.rolloff);
            this.setStereoGain(n, f, f3);
            this.setStereoDelay(n, n4, n5);
        }
    }

    public void muteSample(int n) {
        HAESample hAESample = null;
        hAESample = (HAESample)this.getSample(n);
        if (hAESample == null) {
            return;
        }
        hAESample.setMuteFlag(true);
    }

    public void unmuteSample(int n) {
        HAESample hAESample = null;
        hAESample = (HAESample)this.getSample(n);
        if (hAESample == null) {
            return;
        }
        hAESample.setMuteFlag(false);
        this.reverbDirty = 65535;
        hAESample.setDirtyFlags(65535);
    }

    public long getSampleDuration(int n) {
        long l;
        HAESample hAESample = null;
        hAESample = (HAESample)this.getSample(n);
        if (hAESample == null) {
            return -1L;
        }
        int n2 = hAESample.getDataType();
        int n3 = hAESample.getSoundType();
        if (n2 == 1) {
            l = J3DHaeStream.getSampleDuration(n);
        } else if (n2 == 2) {
            l = J3DHaeClip.getSampleDuration(n);
        } else if (n2 == 3 || n2 == 3) {
            l = J3DHaeMidi.getSampleDuration(n);
        } else {
            return -1L;
        }
        return l;
    }

    public int getNumberOfChannelsUsed(int n) {
        HAESample hAESample = null;
        hAESample = (HAESample)this.getSample(n);
        if (hAESample == null) {
            return 0;
        }
        return this.getNumberOfChannelsUsed(n, hAESample.getMuteFlag());
    }

    public int getNumberOfChannelsUsed(int n, boolean bl) {
        HAESample hAESample = null;
        hAESample = (HAESample)this.getSample(n);
        if (hAESample == null) {
            return 0;
        }
        int n2 = hAESample.getSoundType();
        int n3 = hAESample.getDataType();
        if (n3 == 3 || n3 == 3) {
            return 1;
        }
        if (n2 == 1) {
            return 1;
        }
        return 3;
    }

    public long getStartTime(int n) {
        HAESample hAESample = null;
        hAESample = (HAESample)this.getSample(n);
        if (hAESample == null) {
            return 0L;
        }
        int n2 = hAESample.getDataType();
        int n3 = hAESample.getSoundType();
        if (n2 == 1) {
            return J3DHaeStream.getStartTime(n);
        }
        if (n2 == 2) {
            return J3DHaeClip.getStartTime(n);
        }
        if (n2 == 3 || n2 == 3) {
            return J3DHaeMidi.getStartTime(n);
        }
        return 0L;
    }

    void setStereoGain(int n, float f, float f2) {
        HAESample hAESample = null;
        hAESample = (HAESample)this.getSample(n);
        if (hAESample == null || this.thread == null) {
            return;
        }
        AuralParameters auralParameters = this.getAuralParameters();
        int n2 = hAESample.getDataType();
        int n3 = hAESample.getSoundType();
        boolean bl = hAESample.getMuteFlag();
        float f3 = 0.0f;
        if (!bl && this.reverbOn) {
            f3 = hAESample.getGain() * auralParameters.reflectionCoefficient;
        }
        if (n2 == 1 || n2 == 2) {
            this.thread.setTargetGain(n, f);
            if (n3 == 3 || n3 == 2) {
                this.thread.setTargetGain(((HAEPositionalSample)hAESample).getSecondIndex(), f2);
                this.thread.setTargetGain(((HAEPositionalSample)hAESample).getReverbIndex(), f3);
            }
        } else if (n2 == 3 || n2 == 3) {
            this.thread.setTargetGain(n, f + f2);
        } else {
            return;
        }
    }

    void setStereoDelay(int n, int n2, int n3) {
        HAESample hAESample = null;
        hAESample = (HAESample)this.getSample(n);
        if (hAESample == null) {
            return;
        }
        int n4 = hAESample.getDataType();
        int n5 = hAESample.getSoundType();
        if (n4 == 1) {
            if (n5 == 3 || n5 == 2) {
                J3DHaeStream.setSampleDelay(n, n2);
                J3DHaeStream.setSampleDelay(((HAEPositionalSample)hAESample).getSecondIndex(), n3);
            } else {
                J3DHaeStream.setSampleDelay(n, 0);
            }
        } else if (n4 == 2) {
            if (n5 == 3 || n5 == 2) {
                J3DHaeClip.setSampleDelay(n, n2);
                J3DHaeClip.setSampleDelay(((HAEPositionalSample)hAESample).getSecondIndex(), n3);
            } else {
                J3DHaeClip.setSampleDelay(n, 0);
            }
        } else if (n4 == 3 || n4 == 3) {
            J3DHaeMidi.setSampleDelay(n, 0);
        } else {
            return;
        }
    }

    void scaleSampleRate(int n, boolean bl) {
        HAESample hAESample = null;
        hAESample = (HAESample)this.getSample(n);
        if (hAESample == null || this.thread == null) {
            return;
        }
        float f = hAESample.getTargetRateRatio();
        int n2 = hAESample.getDataType();
        int n3 = hAESample.getSoundType();
        if (n2 == 1 || n2 == 2) {
            if (bl) {
                this.thread.setRate(n, f);
            } else {
                this.thread.setTargetRate(n, f);
            }
            if (n3 != 1) {
                if (bl) {
                    this.thread.setRate(((HAEPositionalSample)hAESample).getSecondIndex(), f);
                    this.thread.setRate(((HAEPositionalSample)hAESample).getReverbIndex(), f);
                } else {
                    this.thread.setTargetRate(((HAEPositionalSample)hAESample).getSecondIndex(), f);
                    this.thread.setTargetRate(((HAEPositionalSample)hAESample).getReverbIndex(), f);
                }
            }
        } else if (n2 == 3 || n2 == 3) {
            if (bl) {
                this.thread.setRate(n, f);
            } else {
                this.thread.setTargetRate(n, f);
            }
        }
    }

    void calcReverb(AuralParameters auralParameters) {
        float f = auralParameters.decayTime;
        float f2 = auralParameters.reverbDelay * auralParameters.rolloff;
        int n = auralParameters.reverbOrder;
        if (auralParameters.reflectionCoefficient == 0.0f || auralParameters.reverbCoefficient == 0.0f) {
            this.reverbOn = false;
        } else {
            float f3;
            this.reverbOn = true;
            if (n > 0 && (f3 = (float)n * f2) < f) {
                f = f3;
            }
            this.reverbType = f2 < 100.0f ? (f <= 1500.0f ? 2 : 4) : (f2 < 500.0f ? (f <= 1500.0f ? 3 : 6) : (f <= 1500.0f ? 6 : 5));
        }
        this.reverbDirty = 0;
    }

    void setReverb(int n) {
        HAESample hAESample = null;
        hAESample = (HAESample)this.getSample(n);
        if (hAESample == null) {
            return;
        }
        int n2 = hAESample.getSoundType();
        int n3 = hAESample.getDataType();
        if (n2 == 3 || n2 == 2) {
            HAEPositionalSample hAEPositionalSample = null;
            hAEPositionalSample = (HAEPositionalSample)this.getSample(n);
            if (hAEPositionalSample == null) {
                return;
            }
            int n4 = hAEPositionalSample.getReverbIndex();
            if (n3 == 1) {
                J3DHaeStream.setReverb(n4, this.reverbType, this.reverbOn);
            } else if (n3 == 2) {
                J3DHaeClip.setReverb(n4, this.reverbType, this.reverbOn);
            } else if (n3 == 3 || n3 == 3) {
                J3DHaeMidi.setReverb(n4, this.reverbType, this.reverbOn);
            }
        }
    }

    public void setLoop(int n, int n2) {
        HAESample hAESample = null;
        hAESample = (HAESample)this.getSample(n);
        if (hAESample == null) {
            return;
        }
        int n3 = hAESample.getDataType();
        if ((n3 == 1 || n3 == 2) && n2 == -1) {
            n2 = 0x7FFFFFF;
        }
        super.setLoop(n, n2);
    }

    void setFilter(int n, boolean bl, float f) {
        HAEPositionalSample hAEPositionalSample = null;
        hAEPositionalSample = (HAEPositionalSample)this.getSample(n);
        if (hAEPositionalSample == null) {
            return;
        }
        int n2 = hAEPositionalSample.getDataType();
        if (n2 == 3 || n2 == 3) {
            return;
        }
        int n3 = hAEPositionalSample.getSecondIndex();
        if (n2 == 2) {
            J3DHaeClip.setFiltering(n, bl, f);
            J3DHaeClip.setFiltering(n3, bl, f);
        } else {
            J3DHaeStream.setFiltering(n, bl, f);
            J3DHaeStream.setFiltering(n3, bl, f);
        }
    }

    public void setGain(float f) {
        float f2 = this.deviceGain;
        float f3 = f / f2;
        this.deviceGain = f;
    }

    public void pause() {
        this.pause = 1;
    }

    public void resume() {
        this.pause = 3;
    }

    public void setRateScaleFactor(int n, float f) {
        HAESample hAESample = null;
        hAESample = (HAESample)this.getSample(n);
        if (hAESample == null) {
            return;
        }
        hAESample.setRateScaleFactor(f);
        this.scaleSampleRate(n, true);
    }

    public void setRolloff(float f) {
        super.setRolloff(f);
        int n = this.getSampleListSize();
        int n2 = 0;
        while (n2 < n) {
            this.scaleSampleRate(n2, true);
            ++n2;
        }
    }

    public void setFrequencyScaleFactor(float f) {
        super.setFrequencyScaleFactor(f);
        int n = this.getSampleListSize();
        int n2 = 0;
        while (n2 < n) {
            this.scaleSampleRate(n2, true);
            ++n2;
        }
    }

    public void setVelocityScaleFactor(float f) {
        super.setVelocityScaleFactor(f);
        int n = this.getSampleListSize();
        int n2 = 0;
        while (n2 < n) {
            this.scaleSampleRate(n2, true);
            ++n2;
        }
    }
}

