/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.headspace;

import com.sun.j3d.audioengines.AudioEngine3D;
import com.sun.j3d.audioengines.AudioEngine3DL2;
import com.sun.j3d.audioengines.AudioEngineThread;
import com.sun.j3d.audioengines.headspace.HAEPositionalSample;
import com.sun.j3d.audioengines.headspace.HAESample;
import com.sun.j3d.audioengines.headspace.J3DHaeClip;
import com.sun.j3d.audioengines.headspace.J3DHaeMidi;
import com.sun.j3d.audioengines.headspace.J3DHaeStream;

class HeadspaceThread
extends AudioEngineThread {
    boolean rampGain = false;
    boolean rampRate = false;
    AudioEngine3D audioEngine = null;

    HeadspaceThread(ThreadGroup threadGroup, AudioEngine3DL2 audioEngine3DL2) {
        super(threadGroup, "HeadspaceThread");
        this.audioEngine = audioEngine3DL2;
    }

    public synchronized void doWork() {
        int n = this.audioEngine.getSampleListSize();
        HAESample hAESample = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            hAESample = (HAESample)this.audioEngine.getSample(n3);
            if (hAESample != null && hAESample.getRampRateFlag()) {
                boolean bl = this.adjustRate(n3);
                hAESample.setRampRateFlag(!bl);
                if (!bl) {
                    ++n2;
                }
            }
            ++n3;
        }
        if (n2 > 0) {
            this.rampRate = true;
            this.runMonitor(2, 0L, null);
        } else {
            this.rampRate = false;
        }
    }

    boolean adjustRate(int n) {
        double d = 0.00130213;
        double d2 = 0.00260417;
        HAESample hAESample = (HAESample)this.audioEngine.getSample(n);
        if (hAESample == null) {
            return false;
        }
        double d3 = hAESample.getCurrentRateRatio();
        double d4 = hAESample.getTargetRateRatio();
        boolean bl = false;
        if (d3 > 0.0) {
            double d5 = d4;
            double d6 = 0.0;
            d6 = d4 - d3;
            if (d6 > 0.0) {
                if (d6 >= d2) {
                    d5 = d3 + d2;
                    bl = false;
                } else {
                    d5 = d4;
                    bl = true;
                }
            } else if (d6 < 0.0) {
                if (-d6 >= d) {
                    d5 = d3 - d;
                    bl = false;
                } else {
                    d5 = d4;
                    bl = true;
                }
            } else {
                return true;
            }
            this.setSampleRate(n, (float)d5);
        } else {
            this.setSampleRate(n, (float)d4);
            bl = false;
        }
        return bl;
    }

    void setGain(int n, float f) {
        this.setSampleGain(n, f);
        this.rampGain = false;
    }

    void setTargetGain(int n, float f) {
        this.setSampleGain(n, f);
        this.rampGain = false;
    }

    void setRate(int n, float f) {
        this.setSampleRate(n, f);
        HAESample hAESample = (HAESample)this.audioEngine.getSample(n);
        if (hAESample == null) {
            return;
        }
        hAESample.setRampRateFlag(false);
    }

    void setTargetRate(int n, float f) {
        HAESample hAESample = (HAESample)this.audioEngine.getSample(n);
        if (hAESample == null) {
            return;
        }
        hAESample.setRampRateFlag(true);
        this.rampRate = true;
        this.runMonitor(2, 0L, null);
    }

    synchronized void setSampleGain(int n, float f) {
        HAESample hAESample = (HAESample)this.audioEngine.getSample(n);
        if (hAESample == null) {
            return;
        }
        int n2 = hAESample.getDataType();
        int n3 = hAESample.getSoundType();
        boolean bl = hAESample.getMuteFlag();
        if (n2 == 1) {
            J3DHaeStream.setSampleGain(n, f);
        } else if (n2 == 2) {
            J3DHaeClip.setSampleGain(n, f);
        } else {
            J3DHaeMidi.setSampleGain(n, f);
        }
    }

    synchronized void setSampleRate(int n, float f) {
        HAEPositionalSample hAEPositionalSample;
        HAESample hAESample = (HAESample)this.audioEngine.getSample(n);
        if (hAESample == null) {
            return;
        }
        int n2 = hAESample.getDataType();
        int n3 = hAESample.getSoundType();
        int n4 = -1;
        int n5 = -1;
        if (n2 == 1) {
            J3DHaeStream.scaleSampleRate(n, f);
            if (n3 == 3 || n3 == 2) {
                n4 = ((HAEPositionalSample)hAESample).getSecondIndex();
                n5 = ((HAEPositionalSample)hAESample).getReverbIndex();
                J3DHaeStream.scaleSampleRate(n4, f);
                J3DHaeStream.scaleSampleRate(n5, f);
            }
        } else if (n2 == 2) {
            J3DHaeClip.scaleSampleRate(n, f);
            if (n3 == 3 || n3 == 2) {
                n4 = ((HAEPositionalSample)hAESample).getSecondIndex();
                n5 = ((HAEPositionalSample)hAESample).getReverbIndex();
                J3DHaeClip.scaleSampleRate(n4, f);
                J3DHaeClip.scaleSampleRate(n5, f);
            }
        }
        if (n2 == 1) {
            J3DHaeStream.scaleSampleRate(n, f);
            if (n3 == 3 || n3 == 2) {
                n4 = ((HAEPositionalSample)hAESample).getSecondIndex();
                n5 = ((HAEPositionalSample)hAESample).getReverbIndex();
                J3DHaeStream.scaleSampleRate(n4, f);
                J3DHaeStream.scaleSampleRate(n5, f);
            }
        } else if (n2 == 2) {
            J3DHaeClip.scaleSampleRate(n, f);
            if (n3 == 3 || n3 == 2) {
                n4 = ((HAEPositionalSample)hAESample).getSecondIndex();
                n5 = ((HAEPositionalSample)hAESample).getReverbIndex();
                J3DHaeClip.scaleSampleRate(n4, f);
                J3DHaeClip.scaleSampleRate(n5, f);
            }
        } else if (n2 == 3 || n2 == 3) {
            J3DHaeMidi.scaleSampleRate(n, f);
        }
        hAESample.setCurrentRateRatio(f);
        if (n4 != -1) {
            hAEPositionalSample = (HAEPositionalSample)this.audioEngine.getSample(n4);
            hAEPositionalSample.setCurrentRateRatio(f);
        }
        if (n5 != -1) {
            hAEPositionalSample = (HAEPositionalSample)this.audioEngine.getSample(n5);
            hAEPositionalSample.setCurrentRateRatio(f);
        }
    }

    public void initialize() {
        super.initialize();
        this.setPriority(1);
    }

    public void cleanup() {
        super.cleanup();
    }
}

