/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.headspace;

import com.sun.j3d.audioengines.headspace.AudioContainerInputStream;
import com.sun.j3d.audioengines.headspace.HaeMidiSong;
import com.sun.j3d.audioengines.headspace.HeadspaceParams;
import com.sun.j3d.audioengines.headspace.J3DHaeClip;
import com.sun.j3d.audioengines.headspace.J3DHaeStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;

class J3DHaeMidi
extends J3DHaeClip {
    J3DHaeMidi() {
    }

    static byte[] getAllBytes(URL uRL) {
        byte[] byArray = null;
        int n = 1000;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        byte[] byArray2 = new byte[n];
        try {
            DataInputStream dataInputStream = new DataInputStream(uRL.openStream());
            byArray = new byte[n3];
            while ((n2 = dataInputStream.read(byArray2, 0, n)) != -1) {
                byte[] byArray3 = byArray;
                byArray = new byte[n3 += n2];
                try {
                    System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    System.arraycopy(byArray2, 0, byArray, byArray3.length, n2);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
        }
        catch (IOException iOException) {
            System.err.println("Could not read into byte array from " + uRL.toString());
            return null;
        }
        return byArray;
    }

    static int loadSample(URL uRL, int n) {
        AudioContainerInputStream audioContainerInputStream = (AudioContainerInputStream)J3DHaeStream.soundStreams.elementAt(n);
        try {
            HaeMidiSong haeMidiSong = new HaeMidiSong(J3DHaeStream.mixer);
            byte[] byArray = J3DHaeMidi.getAllBytes(uRL);
            haeMidiSong.open(byArray);
            J3DHaeStream.soundSamples.setSize(n + 1);
            J3DHaeStream.soundSamples.setElementAt(haeMidiSong, n);
        }
        catch (Exception exception) {
            J3DHaeStream.soundUrls.removeElementAt(n);
            J3DHaeStream.soundParams.removeElementAt(n);
            J3DHaeStream.soundStreams.removeElementAt(n);
            return -1;
        }
        return 0;
    }

    static long getSampleDuration(int n) {
        return -1L;
    }

    static int startSamples(int n, int n2, int n3, float f, float f2, int n4, int n5) {
        return J3DHaeMidi.startSample(n, n3, f);
    }

    static int startSample(int n, int n2, float f) {
        double d = 0.0039;
        double d2 = f;
        if (n < 0) {
            return -1;
        }
        if (J3DHaeStream.soundSamples.size() <= n) {
            return -1;
        }
        if (J3DHaeStream.soundParams.size() <= n) {
            return -1;
        }
        HeadspaceParams headspaceParams = (HeadspaceParams)J3DHaeStream.soundParams.elementAt(n);
        boolean bl = headspaceParams.getReverbFlag();
        float f2 = 0.0f;
        try {
            HaeMidiSong haeMidiSong = (HaeMidiSong)J3DHaeStream.soundSamples.elementAt(n);
            if (haeMidiSong == null) {
                return -1;
            }
            if (n2 == -1) {
                haeMidiSong.setLoopFlag(true);
            } else {
                haeMidiSong.setLoopFlag(false);
            }
            haeMidiSong.start();
        }
        catch (Exception exception) {
            headspaceParams.startTime = 0L;
            return -1;
        }
        headspaceParams.startTime = System.currentTimeMillis();
        return 0;
    }

    static int stopSample(int n) {
        if (n < 0) {
            return -1;
        }
        if (J3DHaeStream.soundSamples.size() <= n) {
            return -1;
        }
        HaeMidiSong haeMidiSong = null;
        haeMidiSong = (HaeMidiSong)J3DHaeStream.soundSamples.elementAt(n);
        if (haeMidiSong == null) {
            return -1;
        }
        haeMidiSong.stop(false);
        HeadspaceParams headspaceParams = (HeadspaceParams)J3DHaeStream.soundParams.elementAt(n);
        headspaceParams.startTime = 0L;
        return 0;
    }

    static int stopSamples(int n, int n2) {
        return J3DHaeMidi.stopSample(n);
    }

    static void setSampleGain(int n, float f) {
        if (n < 0) {
            return;
        }
        if (J3DHaeStream.soundSamples.size() <= n) {
            return;
        }
        Object var2_2 = null;
        HaeMidiSong haeMidiSong = null;
        double d = f;
        haeMidiSong = (HaeMidiSong)J3DHaeStream.soundSamples.elementAt(n);
        if (haeMidiSong == null) {
            return;
        }
        haeMidiSong.setVolume(d);
    }

    static void setSamplePan(int n, float f) {
    }

    static void setReverb(int n, int n2, boolean bl) {
    }

    static void scaleSampleRate(int n, float f) {
    }

    static int pauseSamples(int n, int n2) {
        return J3DHaeMidi.pauseSample(n);
    }

    static int pauseSample(int n) {
        HaeMidiSong haeMidiSong = (HaeMidiSong)J3DHaeStream.soundSamples.elementAt(n);
        if (haeMidiSong == null) {
            return -1;
        }
        haeMidiSong.pause();
        return 0;
    }

    static int unpauseSamples(int n, int n2) {
        return J3DHaeMidi.unpauseSample(n);
    }

    static int unpauseSample(int n) {
        HaeMidiSong haeMidiSong = (HaeMidiSong)J3DHaeStream.soundSamples.elementAt(n);
        if (haeMidiSong == null) {
            return -1;
        }
        haeMidiSong.resume();
        return 0;
    }

    static void setFiltering(int n, boolean bl, float f) {
    }
}

