/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.javasound;

import com.sun.j3d.audioengines.AudioEngine3D;
import com.sun.j3d.audioengines.AudioEngine3DL2;
import com.sun.j3d.audioengines.AudioEngineThread;
import com.sun.j3d.audioengines.javasound.JSAuralParameters;
import com.sun.j3d.audioengines.javasound.JSSample;

class JSThread
extends AudioEngineThread {
    int totalChannels = 0;
    boolean rampGain = false;
    boolean rampRate = false;
    AudioEngine3D audioEngine = null;

    JSThread(ThreadGroup threadGroup, AudioEngine3DL2 audioEngine3DL2) {
        super(threadGroup, "JavaSoundThread");
        this.audioEngine = audioEngine3DL2;
        this.totalChannels = 32;
    }

    public synchronized void doWork() {
        int n = this.audioEngine.getSampleListSize();
        JSSample jSSample = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            jSSample = (JSSample)this.audioEngine.getSample(n3);
            if (jSSample != null && jSSample.getRampRateFlag()) {
                boolean bl = this.adjustRate(jSSample);
                jSSample.setRampRateFlag(!bl);
                if (!bl) {
                    ++n2;
                }
            }
            ++n3;
        }
        if (n2 > 0) {
            this.rampRate = true;
            this.runMonitor(2, 0L, null);
        } else {
            this.rampRate = false;
        }
    }

    int getTotalChannels() {
        return this.totalChannels;
    }

    boolean adjustRate(JSSample jSSample) {
        double d = 0.00130213;
        double d2 = 0.00260417;
        double d3 = jSSample.getCurrentRateRatio();
        double d4 = jSSample.getTargetRateRatio();
        boolean bl = false;
        if (d3 > 0.0) {
            double d5 = d4;
            double d6 = 0.0;
            d6 = d4 - d3;
            if (d6 > 0.0) {
                if (d6 >= d2) {
                    d5 = d3 + d2;
                    bl = false;
                } else {
                    d5 = d4;
                    bl = true;
                }
            } else if (d6 < 0.0) {
                if (-d6 >= d) {
                    d5 = d3 - d;
                    bl = false;
                } else {
                    d5 = d4;
                    bl = true;
                }
            } else {
                return true;
            }
            this.setSampleRate(jSSample, (float)d5);
        } else {
            this.setSampleRate(jSSample, (float)d4);
            bl = false;
        }
        return bl;
    }

    void setSampleRate(JSSample jSSample, JSAuralParameters jSAuralParameters) {
    }

    void setSampleGain(JSSample jSSample, JSAuralParameters jSAuralParameters) {
    }

    void setSampleDelay(JSSample jSSample, JSAuralParameters jSAuralParameters) {
    }

    void setTargetGain(JSSample jSSample, float f) {
    }

    void setRate(JSSample jSSample, float f) {
        this.setSampleRate(jSSample, f);
        jSSample.setRampRateFlag(false);
    }

    void setTargetRate(JSSample jSSample, float f) {
        jSSample.setRampRateFlag(true);
        jSSample.setTargetRateRatio(f);
        this.rampRate = true;
        this.runMonitor(2, 0L, null);
    }

    void setSampleGain(JSSample jSSample, float f) {
    }

    void setSampleRate(JSSample jSSample, float f) {
        jSSample.setCurrentRateRatio(f);
    }

    boolean startSample(JSSample jSSample) {
        return true;
    }

    boolean stopSample(JSSample jSSample) {
        return true;
    }

    void pauseSample(JSSample jSSample) {
    }

    void unpauseSample(JSSample jSSample) {
    }

    void muteSample(JSSample jSSample) {
    }

    void unmuteSample(JSSample jSSample) {
    }

    int startStreams() {
        return 0;
    }

    int startStream() {
        return 0;
    }

    int startClips() {
        return 0;
    }

    int startClip() {
        return 0;
    }

    public void initialize() {
        super.initialize();
    }

    boolean close() {
        return false;
    }

    public void shutdown() {
    }

    public void cleanup() {
        super.cleanup();
    }
}

