package org.cfd.first3d;

import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformAWTBehavior;
import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;

import javax.swing.*;
import javax.media.j3d.*;
import javax.vecmath.Point3d;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;
import java.awt.*;

import org.cfd.first3d.utils.time.TickBehavior;
import org.cfd.first3d.utils.time.TickerListener;
import org.newdawn.j3d.loaders.md3.MD3Loader;
import org.newdawn.j3d.loaders.md3.MD3Model;
import org.newdawn.j3d.loaders.md3.MD3AnimConfig;
import org.newdawn.j3d.loaders.md3.MD3ModelInstance;


public class Test3D  extends JFrame implements TickerListener{

    private BranchGroup rootBranchGroup;
    private SimpleUniverse universe;
    private Canvas3D canvas;

    MD3Model model;
    MD3ModelInstance modelInstance;

    public Test3D() throws Exception {
         super();

        Toolkit k = Toolkit.getDefaultToolkit();
        Dimension tailleEcran = k.getScreenSize();
        int largeurEcran = tailleEcran.width;
        int hauteurEcran = tailleEcran.height;
        setLocation(largeurEcran*1/10, hauteurEcran*1/10);
//        Image JFrameIcon = k.getImage(getClass().getResource("/cassos.gif"));
//        setIconImage(JFrameIcon);



        //fait en sorte que lorsqu'on ferme la fenetre, le programme se ferme aussi
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        //PREPARE LE COMPOSANT GRAPHIQUE ET L UNIVERS QUI CONTIENDRA LA SCENE
        canvas = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 50000.0);
        universe = new SimpleUniverse(canvas);
        universe.getViewingPlatform().setNominalViewingTransform();
        universe.getViewer().getView().setTransparencySortingPolicy(View.TRANSPARENCY_SORT_GEOMETRY);
        universe.setJ3DThreadPriority(Thread.NORM_PRIORITY);


        //PREPARE LE NOEUD RACINE DE TOUTE LA SCENE
        rootBranchGroup = new BranchGroup();
        rootBranchGroup.setCapability(BranchGroup.ENABLE_PICK_REPORTING);
        rootBranchGroup.setCapability(BranchGroup.ALLOW_PICKABLE_READ);
        rootBranchGroup.setCapability(BranchGroup.ALLOW_CHILDREN_EXTEND);
        rootBranchGroup.setCapability(BranchGroup.ALLOW_DETACH);
        rootBranchGroup.setCapability(BranchGroup.ALLOW_CHILDREN_READ);
        rootBranchGroup.setCapability(BranchGroup.ALLOW_CHILDREN_WRITE);


        //********************************CHARGEMENT DE TEST ********************************
//        nwnLoader = new NWNSimpleCharacterLoader("Dragon.mdl");
//        BranchGroup playerGroup = nwnLoader.getPlayerGroup();
//            rootBranchGroup.addChild(playerGroup);
       MD3Loader loader = new MD3Loader();
        model  = loader.loadCharacterModel("dangergirl");
        modelInstance = model.getInstance();
        modelInstance.setAnimation("lower", MD3AnimConfig.IDLE);
        rootBranchGroup.addChild(modelInstance);
        //modelInstance.setAnimation("head", animation);

//        modelInstance.setAnimation("lower", MD3AnimConfig.WALK);

        //********************************CHARGEMENT DE TEST ********************************


        ViewPlatformAWTBehavior vpb = new OrbitBehavior(canvas, OrbitBehavior.REVERSE_ALL);
        vpb.setSchedulingBounds(bounds);
        //distance visible
        universe.getViewer().getView().setFrontClipDistance(0.1f);
        universe.getViewer().getView().setBackClipDistance(20f);
        universe.getViewingPlatform().setViewPlatformBehavior(vpb);

        //ADD LIGHT
        Color3f lColor = new Color3f(1f, 1f, 1f);

        //ambiant
        AmbientLight aLgt = new AmbientLight(lColor);
        aLgt.setInfluencingBounds(bounds);
        aLgt.setEnable(true);
        rootBranchGroup.addChild(aLgt);

        // coming from top
        Vector3f lDir1 = new Vector3f(0f, -1.0f, 0f);
        DirectionalLight lgt1 = new DirectionalLight(lColor, lDir1);
        lgt1.setInfluencingBounds(bounds);
        rootBranchGroup.addChild(lgt1);

        // coming from left
        lDir1 = new Vector3f(1f, 0f, 0f);
        lgt1 = new DirectionalLight(lColor, lDir1);
        lgt1.setInfluencingBounds(bounds);
        rootBranchGroup.addChild(lgt1);

        // coming from right
        lDir1 = new Vector3f(-1f, 0f, 0f);
        lgt1 = new DirectionalLight(lColor, lDir1);
        lgt1.setInfluencingBounds(bounds);
        rootBranchGroup.addChild(lgt1);

        // coming from back
        lDir1 = new Vector3f(0f, 0f, 1f);
        lgt1 = new DirectionalLight(lColor, lDir1);
        lgt1.setInfluencingBounds(bounds);
        rootBranchGroup.addChild(lgt1);

        // coming from front
        lDir1 = new Vector3f(0f, 0f, -1f);
        lgt1 = new DirectionalLight(lColor, lDir1);
        lgt1.setInfluencingBounds(bounds);
        rootBranchGroup.addChild(lgt1);

        //ADD THE FOLLOWING CAMERA
        universe.getViewer().getView().setFrontClipDistance(0.1f);
        universe.getViewer().getView().setBackClipDistance(20f);

//        getContentPane().add(canvas);
        getContentPane().setBackground(Color.BLACK);
        getContentPane().add(canvas);


        //AJOUT DU NOEUD RACINE A L'UNIVERS
//        universe.addBranchGraph(rootBranchGroup);
        universe.addBranchGraph(rootBranchGroup);


        setSize(750, 500);

        System.out.println("Starting ticker...");
        TickBehavior ticker = new TickBehavior(10, bounds, false);
		ticker.addTickerListener(this);
        rootBranchGroup.addChild(ticker.getBranchGroup());
        ticker.startTicking();
    }

    public static void main(String[] args) throws Exception{
        new Test3D().setVisible(true);
    }

    long lastTickTime = 0;
    public void tick(long timePassed) {
//        System.out.println("tick");
//        if(System.currentTimeMillis() - lastTickTime > 100){
            modelInstance.nextFrame("lower");
            lastTickTime = System.currentTimeMillis();
//            System.out.println("tack " + System.currentTimeMillis());
//        }

    }


}
