package org.cfd.first3d.utils.time;

import javax.media.j3d.*;
import java.util.Vector;

/**
 * Created by IntelliJ IDEA.
 * User: Istvald
 * Date: 17 mars 2004
 * Time: 22:50:07
 * To change this template use File | Settings | File Templates.
 */
public class TickBehavior extends Behavior
{

	WakeupCriterion mWakeup;

	private int frameDelay=0;
    private boolean tickEachFrame = false;

    private Vector tickerListeners = new Vector();
    private BranchGroup branchGroup = new BranchGroup();

    private long lastTickTime = 0;


	/**
     * Construit un nouveau TickBehavior. Cet objet permet de prevenir
     * les TickerListeners qui lui seront attachs "fps" fois par seconde
     * (sauf si tickEachFrame est a true, alors a chaque rendu).
     * Pour etre actif son BranchGroup doit etre attach au graph de scene (en utilisant la methode getBranchGroup),
     * les objet dsirant etre appels doivent etre ajout en tant que TickerListeners
     * et il doit etre dmarr via la mthode startTicking();
     * @param fps
     * @param bounds
     * @param tickEachFrame
     */
	public TickBehavior(double fps, Bounds bounds, boolean tickEachFrame )
	{
        this.tickEachFrame = tickEachFrame;
        frameDelay = (int)( 1000.0f / (float)fps );

		this.setSchedulingBounds( bounds );
        this.setEnable( false );
        branchGroup.setCapability(BranchGroup.ALLOW_DETACH);
        branchGroup.addChild(this);

	}

    public void addTickerListener(TickerListener tickerListener){
        tickerListeners.add(tickerListener);
    }

    public void removeTickerListener(TickerListener tickerListener){
        tickerListeners.remove(tickerListener);
    }

    public BranchGroup getBranchGroup() {
        return branchGroup;
    }

    public void initialize()
	{
        // Inscrit cet objet pour etre averti au prochain evenement(prochaine frame ou temps coul)
        if ( tickEachFrame )
        {
    		mWakeup = new WakeupOnElapsedFrames( 0, true );
        }else{
			mWakeup = new WakeupOnElapsedTime( frameDelay );
        }

		this.wakeupOn( mWakeup );
    }



	public void processStimulus( java.util.Enumeration enumeration )
	{
        //Fait ticker tous les TickerListener a l'coute puis remplace lastTickTime par sa la valeur courante
        long currentTime = System.currentTimeMillis();
        for (int i = 0; i < tickerListeners.size(); i++) {
            TickerListener tickerListener = (TickerListener) tickerListeners.elementAt(i);
            if(lastTickTime!=0){
                tickerListener.tick(currentTime -lastTickTime );
            }
        }
        lastTickTime = currentTime;

        // Rinscrit cet objet pour etre averti au prochain evenement(prochaine frame ou temps coul)
        if ( tickEachFrame ){
    		mWakeup = new WakeupOnElapsedFrames( 0, true );
        }else{
            mWakeup = new WakeupOnElapsedTime( frameDelay );
        }
		this.wakeupOn( mWakeup );
	}

	public void startTicking()
	{
		this.setEnable( true );
	}

	public void stopTicking()
	{
		this.setEnable( false );
	}

}